local manipulatebase = require "lightgame.manipulatepartical.manipulatebase"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local detectdefined = require "videodecet.defined"
local mathfunction = require "mathfunction"
local apolloengine = require "apolloengine"
local videodecet = require "videodecet"
local define = require "lightgame.manipulatepartical.defined"


--操纵两个粒子，当信号出现的时候粒子切换粒子
local switch_onesound = manipulatebase:extend();

function switch_onesound:new(patha, pathb, trigger,soundA,queue)
  switch_onesound.super.new(self, trigger,soundA,soundA);
  self.a = apollonode.ParticleNode();
  self.a:CreateResource(patha);
  --renderqueue:Before(self.a);

  self.b = apollonode.ParticleNode();
  self.b:CreateResource(pathb);
  --renderqueue:Before(self.b);

  if queue == nil then
    renderqueue:Queue("Sticker",self.a);
    renderqueue:Queue("Sticker",self.b);
  else
    renderqueue:Queue(queue,self.a);
    renderqueue:Queue(queue,self.b);
  end

  self.switch = true;
  

end

function switch_onesound:SetLocalPosition(pos)
  self.a:SetLocalPosition(pos);
  self.b:SetLocalPosition(pos);
end

 function switch_onesound:_ResetParameter()  --切换为不同的粒子，无需reset
 end

function switch_onesound:_SetTriggerdParam(paramName, value)
  self.b:SetParamMultipiler(paramName,value);
end

function switch_onesound:_SetUnTriggerdParam(paramName, value)
  self.a:SetParamMultipiler(paramName,value);
end

function switch_onesound:_OnDetected(def, globaloffset, globalscale)
  

  if self.switch then
    self.switch = false;
    self.a:SetShow(false);
    self.b:SetShow(true);
  end  
  self.b:SetGlobalOffset(globaloffset);
  self.b:SetGlobalScale(globalscale);
  self.b:AsyncUpdate(def)
  

  

 
end

function switch_onesound:_OnSilence(def)
  if not self.switch then
    self.switch = true;
    self.a:SetShow(true);
    self.b:SetShow(false);
  end  
  self.a:AsyncUpdate(def);
  
  self:PlaySound(2);


end

function switch_onesound:Exit()
  switch_onesound.super:Exit();
  self.a:Destroy();
  self.b:Destroy();
end

return switch_onesound;