local Object        = require "classic"
local apolloengine  = require "apolloengine"
local apollonode    = require "apolloutility.apollonode"
local mathfunction  = require "mathfunction"
local defined       = require "facemorph.defined"

local RenderPassBase = Object:extend();

function RenderPassBase:new()  
  self.points = {}; 
  self.texs  = {};
  self.texCoords = {};
  self.outputTex = nil;
  self.renderNode = nil;
end

function RenderPassBase:Clear()
  if self.morphCamera then
    self.morphCamera:Destroy();
  end
  
  if self.renderNode then
    self.renderNode:Destroy();
  end
  
  self.points = {}; 
  self.texs  = {};
  self.texCoords = {};
end

function RenderPassBase:ReleaseResource()
  self:Clear()
end

-- Setshow 
function RenderPassBase:SetShow(show)
  if self.renderNode ~= nil then
    self.renderNode:SetShow(show);
  end
end

function RenderPassBase:ResetBuffer(index, tex, size, landmarks)
  self.texs[index] = tex;
  self.points[index] = landmarks;
end

function RenderPassBase:GetTargetTexture()
  return self.outputTex;
end

function RenderPassBase:SetFboSize(fbosize)
  LOG("SetFboSize");
  if self.morphCamera then
    self.morphCamera:Destroy();
  end
  self.morphCamera = apollonode.CameraNode();
  self.morphCamera:Activate();
  self.morphCamera:SetSequence(defined.SEQUENCE);
  self.morphCamera:SetClearColor(mathfunction.Color(0.0, 0.0, 0.0, 0.0));
  self.rt, self.outputTex = self:_CreateRenderTarget(fbosize);
  self.morphCamera:AttachRenderTarget(self.rt);
end

-- Create RT context
function RenderPassBase:_CreateRenderTarget(size)      
  --local clear_color = mathfunction.Color(0.0, 0.0, 0.0, 0.0); -- move to camera
  
  local rt = apolloengine.RenderTargetEntity();
  rt:PushMetadata(apolloengine.RenderTargetMetadata(apolloengine.RenderTargetEntity.RT_RENDER_TARGET_2D,
                                                    apolloengine.RenderTargetEntity.ST_SWAP_UNIQUE,
                                                    mathfunction.vector4(0,0,size:x(), size:y()),
                                                    size)
                  );

  local tex = rt:MakeTextureAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
  tex:PushMetadata(apolloengine.TextureBufferMetadata(size,
                                                      apolloengine.TextureEntity.TT_TEXTURE2D,
                                                      apolloengine.TextureEntity.TU_READ,
                                                      apolloengine.TextureEntity.PF_R8G8B8A8,
                                                      1, false,
                                                      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                                                      apolloengine.TextureEntity.TW_CLAMP_TO_EDGE,
                                                      apolloengine.TextureEntity.TF_LINEAR,
                                                      apolloengine.TextureEntity.TF_LINEAR));                                                  
                                                          
  
  rt:CreateResource();

  return rt, tex;
end

return RenderPassBase;
