local venuscore = require "venuscore"
local soundeffect = require "facecute.soundeffect.soundeffect"
local soundeffect3New = soundeffect:extend();


function soundeffect3New:new()
  soundeffect3New.super.new(self);
  self.name = nil
end

--传入数据表，解析数据
function soundeffect3New:ParseConfig(m, param)
  self.path = param[1].."/"..m.name;
  self.path = venuscore.IFileSystem:PathAssembly(self.path);

  local res = self.soundplayer:LoadSound(self.path);
  return res;
end

function soundeffect3New:getAsset(name)
  if (name == self.name) then
    return self
  end
  return nil;
end

function soundeffect3New:SetShow(isshow)
  if isshow then
    self.soundplayer:ResumeSound()
  else
    self.soundplayer:PauseSound()
  end
end

----------

function soundeffect3New:SetRootNode(rootNode)
end

function soundeffect3New:Finished()
  return not self.soundplayer:isPlaying()
end

function soundeffect3New:SeekToFirst()
end

function soundeffect3New:SeekToMiddle()
end

function soundeffect3New:SeekToLast()
end

function soundeffect3New:Show(args)
end

function soundeffect3New:Hide(args)
  self.soundplayer:StopSound();
end

function soundeffect3New:Start(args)
  if self.soundplayer:isPlaying() then
    self.soundplayer:ResumeSound();
  else
    self.loop = tonumber(args.loop);
    self.soundplayer:PlaySound(self.loop);
  end
end

function soundeffect3New:Stop(args)
  if args.fading == nil then
    self.soundplayer:PauseSound();
  end
end

function soundeffect3New:Update(timespan, face, position, rotation, action)

end


function soundeffect3New:SetFade(fade, args)
  if args ~= nil then
    self.soundplayer:FadingSound(args.initialFading, args.deltaFading)
  end
end

-----------




return soundeffect3New;