local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"


local rectnode = rendernode:extend();
function rectnode:new()

  rectnode.super.new(self);
  self.vertexstream = apolloengine.VertexStream();--创建顶点流
  self.indicesstream = apolloengine.IndicesStream();--创建索引流
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
    apolloengine.VertexBufferEntity.DT_FLOAT,
    apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
    4);
	self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
		apolloengine.VertexBufferEntity.DT_FLOAT,
		apolloengine.VertexBufferEntity.DT_HALF_FLOAT,
		2);
  self.indicesstream:SetIndicesType(
    apolloengine.IndicesBufferEntity.IT_UINT16);
end


function rectnode:CreateResource( rectPos,material)
  self.vertexstream:ReserveBuffer(4);--预先分配pointcount + 1个顶点的内存
  self.indicesstream:ReserveBuffer(6);--预先分配pointcount + 2个索引
  for i=1,4 do
       self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
      mathfunction.vector4(rectPos[2*i-1],rectPos[2*i],0,1)
    );
    end
  		  self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(0.0,0.0));
      		  self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(1.0,0.0));
          		  self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(0.0,1.0));
              		  self.vertexstream:PushVertexData(
      apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
      mathfunction.vector2(
        1.0,1.0));
    
      	--	  self.vertexstream:PushVertexData(
    --  apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
     -- mathfunction.vector2(0.0,0.0));
      --		  self.vertexstream:PushVertexData(
     -- apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
      --mathfunction.vector2(1.0,0.0));
       --   		  self.vertexstream:PushVertexData(
      --apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
     -- mathfunction.vector2(0.0,1.0));
       --       		  self.vertexstream:PushVertexData(
    --  apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE1,
     -- mathfunction.vector2(
     --   1.0,1.0));
    
    
    local indices={2,1,0,2,3,1};
    for i=1,6 do
          self.indicesstream:PushIndicesData(indices[i]);
    end
    
  --第三个参数修改为索引模式（RM_TRIANGLES等）
  rectnode.super.CreateResource(
    self,
    material,
    apolloengine.RenderComponent.RM_TRIANGLES,
    self.vertexstream,
    self.indicesstream);
end

return rectnode;