local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local vnectdectionservice = {}

function vnectdectionservice:Initialize(modelpath)
    self.mnn = venuscore.IServicesSystem:CreateFixed("scrs:avatar/posedection/vnectdection_bigonn.lua");
    self.mnn:Initialize(modelpath);
    
    pos2d,pos3dret,scores = self:GetHackedPose();
    self.pos2d = {};
    self.pos3d = {};
    self.score = {};
    self.len = {};
    self.rot = {};
    
    for i=1,3 do
      self.pos2d[i] = pos2d;
      self.pos3d[i] = pos3dret;
      self.score[i] = scores;
      self.rot[i],self.len[i] = self:pos2rotlen(pos3dret);
    end

    self.texturesteam = apolloengine.TextureStream();
    self.index = 1;
end

function vnectdectionservice:Estimate(image)
  if  self.index == 2 then
      self.index = 1
  else
      self.index = self.index+1
      self:InsertResult( self.mnn:GetResult());
      image:Serialize();
      self.mnn:AsyncEstimate(image);
     
  end
  return self:GetResult(self.index);
end

function vnectdectionservice:InsertResult(pos2d,pos3d,scores)
     
  self.pos2d[1] =  self.pos2d[3];
  self.pos3d[1] =  self.pos3d[3];
  self.score[1] =  self.score[3];
  

  self.pos2d[3] = pos2d;
  self.pos3d[3] = pos3d;
  self.score[3] = scores;
  
  self.pos2d[2] = self:tbl_copy(self:Lerp2D(self.pos2d[3],self.pos2d[1],0.5));
  self.score[2] =  self.score[3];
  
  
  self.len[1] = self.len[3];
  self.rot[1] = self.rot[3];
  
  self.rot[3], self.len[3] = self:pos2rotlen(pos3d);
  
  self.rot[2], self.len[2] = self:Slerp(self.len[3],self.rot[3],self.len[1],self.rot[1],0.5);
  self.pos3d[2] = self:rotlen2pos(self.len[2],self.rot[2]);
  
end

function vnectdectionservice:Lerp2D(pospre,poslast,weight)
  local ret = {};
  for i=1,14 do
    ret[i] = {};
    for j=1,2 do
      ret[i][j] = (pospre[i][j]+poslast[i][j])/2;
    end
  end
  return ret;
end

function vnectdectionservice:Slerp(prelen,prerot,nxtlen,nxtrot,weight)
  local retlen = {};
  local retrot = {};
  for i=1,14 do
    retlen[i] = (prelen[i]+nxtlen[i])/2;
    retrot[i] = mathfunction.Mathutility:Slerp(prerot[i],nxtrot[i],0.5);
  end
  return retrot,retlen;
end

function vnectdectionservice:rotlen2pos(len,rot)
  local parentidx = {0,1,2,0,4,5,0,7,8,0,10,11,0,13};
  local updir = mathfunction.vector3(0,0,1);
  local dir = {};
  local ret = {};
  for i=1,14 do
    ret[i] = {};
    local retdir = updir*rot[i];
    local paridx = parentidx[i];
    local retpos = retdir*len[i];
    ret[i][1] = retpos:x();
    ret[i][2] = retpos:y();
    ret[i][3] = retpos:z();
    
    dir[i] = retdir;
    
    if paridx ~= 0 then 
      ret[i][1] = ret[paridx][1]+ret[i][1];
      ret[i][2] = ret[paridx][2]+ret[i][2];
      ret[i][3] = ret[paridx][3]+ret[i][3];
    end
  end
  return ret;
end

function vnectdectionservice:pos2rotlen(pos3d)
  local parentidx = {0,1,2,0,4,5,0,7,8,0,10,11,0,13};
  local dirlist = {};
  for i=1,14 do
    dirlist[i]={};
    local paridx = parentidx[i];
    if paridx==0 then
      dirlist[i] = self:tbl_copy(pos3d[i]);
    else
      for j=1,3 do
        dirlist[i][j] = pos3d[i][j] - pos3d[paridx][j]
      end
    end
  end
  
  local rotlist = {}
  local lengthlist = {}
  
  for i=1,14 do
    rotlist[i] = mathfunction.Quaternion();
    
    local dirvec3 = mathfunction.vector3(dirlist[i][1],dirlist[i][2],dirlist[i][3]);

    lengthlist[i] = dirvec3:Length();
    dirvec3:NormalizeSelf();
    local updir = mathfunction.vector3(0,0,1);
    local paridx = parentidx[i];
    
    rotlist[i]:AxisToAxis(updir,dirvec3);
    
  end
  return rotlist,lengthlist;
end

function vnectdectionservice:GetResult(index)
  if index ==2 then
    return self:tbl_copy(self.pos2d[1]), self:tbl_copy(self.pos3d[1]) ,self:tbl_copy(self.score[1]);
  else
    return self:tbl_copy(self.pos2d[2]), self:tbl_copy(self.pos3d[2]) ,self:tbl_copy(self.score[2]);
  end
end

function vnectdectionservice:Wait()
  
end

function vnectdectionservice:tbl_copy(orig)
    local orig_type = type(orig)
    local copy
    if orig_type == "table" then
        copy = {}
        for orig_key, orig_value in next, orig, nil do
            copy[self:tbl_copy(orig_key)] = self:tbl_copy(orig_value)
        end
    else -- number, string, boolean, etc
        copy = orig
    end
    return copy
end

function vnectdectionservice:GetHackedPose()
     pos2d =    {{ 4.5        , 8.6 },
              { 4.0625     , 11.22},
              { 4.0625     , 13.239},
              {6.9375     , 17.2173913 },
              {7.375      , 11.152},
              {7.375      , 12.7825},
              {5.        , 13.304},
              {5.        , 18.4345},
              {5.        , 19.04347},
              {6.4375     , 13.239},
              {6.4375     , 16.4348261},
              {6.4375     , 19.5        },
              {5.5        , 7.56},
              {5.5        , 5.93}}
    pos3dret = {{-138, -461,  -67},
                  {-210, -185,  -32},
                  {-199,   30,  -53},
                  { 149, -431, -103},
                  { 210, -181,  -56},
                  { 215,   52,  -27},
                  { -83,   32,    0},
                  { -86,  462,   46},
                  { -83,  820,  133},
                  { 108,   48,  -20},
                  {  86,  472,   45},
                  {  88,  819,   82},
                  { -18, -552,  -83},
                  {   7, -745,  -86}}
    scores = {10,10,10,10,10,10,10,10,10,10,10,10,10,10}
    return pos2d, pos3dret, scores;
  end

return vnectdectionservice;















