local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
require "venusdebug"
require "utility"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local poseestimate = require "avatar.poseestimate_combo"


local avatartest = {}

--逻辑模型需要按照3d姿态估计的Tpose的骨骼节点相对位置来制作，按理说应该在xy平面之上
--2d到3d的映射位置不相符，部分信息丢失，导致现在识别出来的驱赶数据不准确
--模型中骨骼的位置与2d追踪的位置不相符，导致计算出来的骨骼位置存在问题，导致最后ik出来的整体躯干不好
function avatartest:Initialize()
  poseestimate:Initialize();

  self.direct = apollonode.LightNode(apolloengine.LightComponent.LT_DIRECTIONAL);
  self.direct:SetColor(
    mathfunction.vector3(1,1,1));
  self.direct:SetLocalDirection(
    mathfunction.vector3(0,-1,-1));

  return true;
end
local i = 0;
function avatartest:Update(def)
  local result = poseestimate:Estimates(def)
  --local result = poseestimate:TPose()
  if result == false then
    return;
  end

  poseestimate:Render();
  
end


return avatartest;