local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local faceinfo = require "videodecet.faceinfo"
local facelift = require "apolloutility.posteffect.facelift.facelift"
local utility = require "apolloutility.nodeutility"

local pfaceliftingMicroShaping = {}

pfaceliftingMicroShaping.BigEye = 0;
pfaceliftingMicroShaping.Queue = 200;

function pfaceliftingMicroShaping:Initialize(host, size)
  
  self.WrapS = apolloengine.TextureEntity.TW_CLAMP_TO_EDGE;
  self.WrapT = apolloengine.TextureEntity.TW_CLAMP_TO_EDGE;
  
  self.UNIFORM_LEFT_EYES = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_LEFT_EYES");
  self.UNIFORM_RIGHT_EYES = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_RIGHT_EYES");
  self.UNIFORM_RATIOASPECT = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                           "UNIFORM_RATIOASPECT");
  self.UNIFORM_LEFT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_LEFT_PTS");
  self.UNIFORM_RIGHT_PTS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_RIGHT_PTS");
  self.UNIFORM_FOREHEAD = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_FOREHEAD");
  self.UNIFORM_CHINCOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_CHINCOEF");                                                                    
  self.UNIFORM_NOSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                    "UNIFORM_NOSE");
  self.UNIFORM_MOUSE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                     "UNIFORM_MOUSE");  
  self.UNIFORM_FACESNUM = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_FACESNUM");
  self.UNIFORM_CHIN = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                    "UNIFORM_CHIN");                                                             
                                                              
  self.UNIFORM_LEFT_MOUTH = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_LEFT_MOUTH");
  self.UNIFORM_RIGHT_MOUTH = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_RIGHT_MOUTH");
  self.UNIFORM_FACECOEF = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                        "UNIFORM_FACECOEF");
  self.UNIFORM_EYE_LARGE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_EYE_LARGE");
  self.UNIFORM_FACE_NARROW = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_FACE_NARROW");
  self.UNIFORM_CHIN_LENG = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_CHIN_LENG");
                                                                       
  self.UNIFORM_NOSE_NARROW = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_NOSE_NARROW");
  self.UNIFORM_NOSE_LENG = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_NOSE_LENG");		
  self.UNIFORM_CANTHUS_OPEN = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,																		 
                                                                         "UNIFORM_CANTHUS_OPEN");
  self.UNIFORM_CANTHUS_ANGLE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_CANTHUS_ANGLE");
  self.UNIFORM_EYE_DIS = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,																		 
                                                                         "UNIFORM_EYE_DIS");
  self.UNIFORM_MOUTH = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_MOUTH");	
  self.UNIFORM_MACINTOSH = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_MACINTOSH");
  self.UNIFORM_LINE_HAIR = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,																		 
                                                                         "UNIFORM_LINE_HAIR");
  self.UNIFORM_NOSE_HUMP = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_NOSE_HUMP");	
  self.UNIFORM_NOSE_HUMP_RATE = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_NOSE_HUMP_RATE");	
  self.UNIFORM_PHILTRUM_LENG = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,																		 
                                                                         "UNIFORM_PHILTRUM_LENG");	                                                                    

  self.UNIFORM_FACES_BOX = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_FACES_BOX");
  self.UNIFORM_SCALERATIO = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                         "UNIFORM_SCALERATIO");
  -----3 lift face param
  self.FACEONEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                  "FACEONEPARA");
  self.FACETWOPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                  "FACETWOPARA");
  self.MOUSEPARA = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,
                                                                "MOUSEPARA");

  local vs, is = utility.Tesslate(128, 72, false, true);

  self.meta = apolloengine.RenderObjectMeshMetadate( 
        apolloengine.RenderComponent.RM_TRIANGLES,
        apolloengine.ReferenceVertexMetadata(        
          apolloengine.VertexBufferEntity.MU_STATIC,--使用可以修改的显存区域
          vs),
        apolloengine.ReferenceIndicesMetadata(
          apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
          is));

  self.BigEye = host:CreateRenderObject(
    "comm:documents/material/biggereyesMcroShaping.material",
    self.meta);
  
  
  self.aspect_ratio = size:y()/size:x();
  self.BigEye:SetParameter(self.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));
  
  local lefteyes = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_LEFT_EYES, lefteyes);
  local righteyes = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_RIGHT_EYES, righteyes);
  local leftPointArray = mathfunction.vector2array();  
  self.BigEye:SetParameter(self.UNIFORM_LEFT_PTS, leftPointArray);
  local rightPointArray = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_RIGHT_PTS, rightPointArray);
  
  local foreheadPointArray = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_FOREHEAD, foreheadPointArray);
  
  local nose = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_NOSE, nose);
  local mouse = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_MOUSE, mouse);
  local chin = mathfunction.vector2array();
  self.BigEye:SetParameter(self.UNIFORM_CHIN, chin);

  local faceCoef = mathfunction.vector2();
  self.BigEye:SetParameter(self.UNIFORM_FACECOEF, faceCoef);
  local eyeLarge = mathfunction.vector2();
  self.BigEye:SetParameter(self.UNIFORM_EYE_LARGE, eyeLarge);
  local narrowfaceCoef = mathfunction.vector2();
  self.BigEye:SetParameter(self.UNIFORM_FACE_NARROW, narrowfaceCoef);
  local lengchinCoef = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_CHIN_LENG,lengchinCoef);
  local narrownoseCoef = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_NOSE_NARROW,narrownoseCoef);
  local lengnoseCoef = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_NOSE_LENG,lengnoseCoef);
  local diseye = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_EYE_DIS,diseye);
  local mouth = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_MOUTH,mouth);
  local macintosh = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_MACINTOSH,macintosh);
  local hairline = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_LINE_HAIR,hairline);
  local nosehump = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_NOSE_HUMP,nosehump);
  local nosehump_rate = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_NOSE_HUMP_RATE,nosehump_rate);
  local lengphiltrum = mathfunction.vector1(0);                
  self.BigEye:SetParameter(self.UNIFORM_PHILTRUM_LENG,lengphiltrum);
  local opencanthus = mathfunction.vector2();
  self.BigEye:SetParameter(self.UNIFORM_CANTHUS_OPEN, opencanthus);
  local anglecanthus = mathfunction.vector2();
  self.BigEye:SetParameter(self.UNIFORM_CANTHUS_ANGLE, anglecanthus);

  local facebox = mathfunction.vector4array();
  self.BigEye:SetParameter(self.UNIFORM_FACES_BOX, facebox);

  return self.Queue;
  
end

function pfaceliftingMicroShaping:Resizeview(size)
  
  self.aspect_ratio = size:y()/size:x();
  self.BigEye:SetParameter(self.UNIFORM_RATIOASPECT, mathfunction.vector1(self.aspect_ratio));

end

function pfaceliftingMicroShaping:Process(pipeline, Original, Scene, Output)
  
  local texture =  Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 )
  local wrap = texture:GetWrap();
  texture:SetWrap(self.WrapS,self.WrapT);
  
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.BigEye:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
  self.BigEye:Draw(pipeline);
  
  texture:SetWrap(wrap[1],wrap[2]);

end

return pfaceliftingMicroShaping;
