local mathfunction = require "mathfunction"
local stringsplit = require "stringsplit"
local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'

local particlepositionmanipulate = b3.Class("ParticlePositionManipulate", b3.Action)

function particlepositionmanipulate:ctor(properties)
	b3.Action.ctor(self)	
	self.name = "ParticlePositionManipulate"
  self.zoom = stringsplit(properties.Scale, ",", tonumber);
  self.range = stringsplit(properties.Range, ",", tonumber);
  self.globaloffset = {0,0,0};
  self.globaloffsetvector = mathfunction.vector3();
end


local fclamp = math.clamp;
function particlepositionmanipulate:tick(tick)
  local action = tick.blackboard:get("activetarget");
  if action == nil then
     return b3.SUCCESS;
  end
  
  local pos = action:GetCenter();
  local rect = action:GetRect();
  local diangle = math.sqrt((rect[1] - rect[3])^2 + (rect[2] - rect[4])^2);
  if not self.lastpos then
    self.lastpos = pos;
    self.lastdiangle = diangle;
  end
  local zoom = self.zoom;
  local ox = zoom[1] * (pos[1] - self.lastpos[1])
  local oy = zoom[2] * (pos[2] - self.lastpos[2])
  local oz = zoom[3] * (diangle - self.lastdiangle);    
  --LOG("x:"..tostring(ox).." y:"..tostring(oy).." z:"..tostring(oz));
  local range = self.range;
  local go = self.globaloffset;
  go[1] = fclamp(go[1] + ox, -range[1], range[1]);
  go[2] = fclamp(go[2] + oy, -range[2], range[2]);
  go[3] = fclamp(go[3] + oz, -range[3], range[3]);
  
  self.globaloffsetvector:Set(go[1], go[2], go[3]);
  --LOG(self.globaloffsetvector);
  
  local particles = tick.blackboard:get("particlescope");
  for _,p in ipairs(particles) do
    p:SetGlobalOffset(self.globaloffsetvector);
  end
  self.lastpos = pos;
  self.lastdiangle = diangle;
  return b3.SUCCESS;
end

return particlepositionmanipulate;