local b3 = require 'behavior3.b3';
require 'behavior3.core.Action'
local soundplayer = require "soundplayer"
local stringsplit = require "stringsplit"

local particleparammusic = b3.Class("ParticleParamMusic", b3.Action)

local function LinearCallback(offset,key_value)  --线性插值
  local len = #key_value;
  local low = 1;
  local high = len;
  local middle = 1;

  while low <= high do
    middle = math.floor((low + high) / 2);
    local pointoffset = key_value[middle][1];
    if pointoffset > offset then
      high = middle - 1;
    elseif pointoffset < offset then
      low = middle + 1;
    else
      return key_value[middle][2];
    end
  end
  
  if key_value[middle][1] > offset then
    middle = middle - 1;
  end
  local first = middle;
  local second = middle + 1;
  if second > len then
    return key_value[len][2];
  end
  if first < 0 then
    return key_value[1][2];
  end
  local offsetFirst = key_value[first][1];
  local offsetSecond = key_value[second][1];
  local pointFirst = key_value[first][2];
  local pointSecond = key_value[second][2];
  --线性插值
  return pointFirst + (pointSecond - pointFirst) * ((offset - offsetFirst) / (offsetSecond - offsetFirst));
end

function particleparammusic:ctor(properties)
	b3.Action.ctor(self)	
	self.name = "ParticleParamMusic";
  self.paramname = properties.paramname;
  self.curves = {}
  for k,v in pairs(properties) do
    if string.find(k, "curve") then
      local t = stringsplit(v, ",", tonumber);
      table.insert(self.curves, t);
    end
  end
end

function particleparammusic:tick(tick)  
  local volume = soundplayer.GetVolume();
  local value = LinearCallback(volume, self.curves);
  local particles = tick.blackboard:get("particlescope");
  for _,p in ipairs(particles) do
    local globaloffset = p.globaloffset;
    local globalscale = p.globalscale;
    if self.paramname == "OFFSETX" then
      globaloffset:Set(value,globaloffset:y(),globaloffset:z());
    elseif self.paramname == "OFFSETY" then
      globaloffset:Set(globaloffset:x(),value,globaloffset:z());
    elseif self.paramname == "OFFSETZ" then
      globaloffset:Set(globaloffset:x(),globaloffset:y(),value);
    elseif self.paramname == "SCALEX" then
      globalscale:Set(value,globalscale:y(),globalscale:z());
    elseif self.paramname == "SCALEY" then
      globalscale:Set(globalscale:x(),value,globalscale:z());
    elseif self.paramname == "SCALEZ" then
      globalscale:Set(globalscale:x(),globalscale:y(),value);
    else
     p:SetParamMultipiler(self.paramname, value);
    end
    p:SetGlobalOffset(globaloffset);
    p:SetGlobalScale(globalscale);
  end
  return b3.SUCCESS;
end

return particleparammusic;