
#include "functions/skin.function"


#SHADER_DEFINE SkinFragmentDirection

    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,		"in_Coordinate" },
		{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,				"in_ViewDirection"},
		{ LIGHT_GIVEN_DIRECTION,			LOW,			VEC3,					"in_LightDirection"},
        { LIGHT_COLOR, 							MEDIUM,		VEC3,		"in_LightColor"},
        { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
        { TEXTURE_BECKMANN,			  NONE,			TEXTURE2D,		"beckmannTex" },
        { TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
        { AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
        { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
        { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
        { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
        { WORLDSPACE_NORMAL,         	HIGH,    		VEC3,        	"in_NormalWS" },
		{ WORLDSPACE_TANGENT,   		HIGH, 	 		VEC3,    		"in_TangentWS"},
    }

    FUNCTION_OUTPUT =
    {
		{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
		{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
		{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
		{ AO_VALUE,				HIGH,			FLOAT,				"occlusion" },
		{ Base_Reflectivity,						LOW,			VEC3,					"F0"},
        { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
		{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"normal" },
    }

#SHADER_CODE
	vec3 wNormal = normalize(in_NormalWS);
	vec3 wTangent = normalize(in_TangentWS);
	wTangent = normalize(wTangent - dot(wTangent, wNormal) * wNormal);
	vec3 wBiTangent = cross(wNormal, wTangent);
	mat3 out_TBN = mat3(wTangent,wBiTangent,wNormal);
	
	vec3 normal0 = normalize(texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0);
    vec3 normal = normalize(out_TBN*normal0);

    vec4 albedo = texture2D(diffuseMap, in_Coordinate);  //diffusetex  模型贴图
    vec3 specularAO = vec3(1.0,0.5,1.0);  //高光贴图   没有，直接写死

    float intensity = specularAO.r;
    float roughness = specularAO.g;
    float occlusion = specularAO.b;
	vec3 F0 = vec3(0.028);
	float metallic = 0.0;
	
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    vec3 light = -normalize(in_LightDirection);


    // Calculate the diffuse and specular lighting:
	vec3 diffuse = vec3(saturate(dot(light, normal)));
    float specular = intensity * SpecularKSK(normal, light, normalize(in_ViewDirection),1.0-roughness,beckmannTex);   //beckmannTex法线分布函数
    float expFactor = exp(60.0 * ( in_TexDepth - in_OrigDepth ));
    expFactor = clamp(expFactor, 0.0, 1.0);

    // Add the diffuse and specular components:
    color.rgb += (albedo.rgb * diffuse + max(specular,0.0)) * expFactor * mix(in_LightColor,in_TransparentColor.xyz,in_TransparentColor.a); //BRDF

    color.rgb += SSSSTransmittance(0.9, 0.005, 0.010, 0.02, normal, light,  in_TexDepth, in_OrigDepth);   //透射


    vec4 in_SurfaceColor =  vec4(color.rgb,1.0);



#END_CODE
#END_DEFINE

#SHADER_DEFINE SkinFragmentDirectionTransparent

    FUNCTION_INPUT =
    {
		{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,				"in_ViewDirection"},
		{ LIGHT_GIVEN_DIRECTION,			LOW,			VEC3,					"in_LightDirection"},
          { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,		"in_Coordinate" },
        { LIGHT_COLOR, 							MEDIUM,		VEC3,		"in_LightColor"},
        { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
        { TEXTURE_BECKMANN,			  NONE,			TEXTURE2D,		"beckmannTex" },
        { TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
        { AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
        { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
        { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
        { WORLDSPACE_NORMAL,         	HIGH,    		VEC3,        	"in_NormalWS" },
		{ WORLDSPACE_TANGENT,   		HIGH, 	 		VEC3,    		"in_TangentWS"},
    }

    FUNCTION_OUTPUT =
    {
		{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
		{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
		{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
		{ AO_VALUE,				HIGH,			FLOAT,				"occlusion" },
		{ Base_Reflectivity,						LOW,			VEC3,					"F0"},
        { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
		{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"normal" },
    }

#SHADER_CODE

	vec3 wNormal = normalize(in_NormalWS);
	vec3 wTangent = normalize(in_TangentWS);
	wTangent = normalize(wTangent - dot(wTangent, wNormal) * wNormal);
	vec3 wBiTangent = cross(wNormal, wTangent);
	mat3 out_TBN = mat3(wTangent,wBiTangent,wNormal);
	
    vec3 normal0 = normalize(texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0);
	vec3 normal = normalize(out_TBN*normal0);
	
    vec4 albedo = texture2D(diffuseMap, in_Coordinate);  //diffusetex  模型贴图
    vec3 specularAO = vec3(1.0,0.5,1.0);  //高光贴图   没有，直接写死

    float occlusion = specularAO.b;
    float intensity = specularAO.r;
    float roughness = specularAO.g;
	vec3 F0 = vec3(0.028);
	float metallic = 0.0;
	
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
    vec3 light = -normalize(in_LightDirection);


    // Calculate the diffuse and specular lighting:
    vec3 diffuse = vec3(saturate(dot(light, normal)));
    float specular = intensity * SpecularKSK(normal, light, normalize(in_ViewDirection), 1.0-roughness,beckmannTex);   //beckmannTex法线分布函数
    float expFactor = exp(60.0 * ( in_TexDepth - in_OrigDepth ));
    expFactor = clamp(expFactor, 0.0, 1.0);

    // Add the diffuse and specular components:
    color.rgb += (albedo.rgb * diffuse + specular) * expFactor * in_LightColor; //BRDF

    color.rgb += SSSSTransmittance(0.9, 0.005, 0.010, 0.02, normal, light,  in_TexDepth, in_OrigDepth);   //透射


    vec4 in_SurfaceColor = color;

#END_CODE
#END_DEFINE

#SHADER_DEFINE SkinFragmentSpot

    FUNCTION_INPUT =
    {
		{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,				"in_ViewDirection"},
		{ LIGHT_VERTEX_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
        { LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_SpotDirection" },
        { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,		"in_Coordinate" },
        { LIGHT_COLOR, 							MEDIUM,		VEC3,		"in_LightColor"},
        { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
        { TEXTURE_BECKMANN,			  NONE,			TEXTURE2D,		"beckmannTex" },
        { TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
        { AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
        { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
        { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
        { SHADOWMAP_COLOR,				HIGH,	VEC4,		"in_TransparentColor" },
        { LIGHT_RANGE_INV,				MEDIUM,		FLOAT,		"in_RangeInv" },
        { LIGHT_ATTENUATION,			MEDIUM,		VEC4,		"in_LinghtAtten" },
        { LIGHT_INNER_DIFF_INV,			MEDIUM,		VEC2,		"in_vInner_DiffInv" },
        { WORLDSPACE_NORMAL,         	HIGH,    		VEC3,        	"in_NormalWS" },
		{ WORLDSPACE_TANGENT,   		HIGH, 	 		VEC3,    		"in_TangentWS"},

    }

    FUNCTION_OUTPUT =
    {
		{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
		{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
		{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
		{ AO_VALUE,				HIGH,			FLOAT,				"occlusion" },
		{ Base_Reflectivity,						LOW,			VEC3,					"F0"},
        { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
		{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"normal" }
    }

#SHADER_CODE

    float dis = length( in_LightDirection );
	float disRange = clamp( dis * in_RangeInv, 0.0, 1.0 );
	float g_fAttenuation = (1.0 - disRange ) / ( in_LinghtAtten.x + disRange * in_LinghtAtten.y + disRange * disRange * in_LinghtAtten.z );
	float attenAngle = clamp( 1.0 - ( in_vInner_DiffInv.x - dot(normalize( in_LightDirection ), -in_SpotDirection) ) * in_vInner_DiffInv.y, 0.0, 1.0 );
    g_fAttenuation *= attenAngle;


	vec3 wNormal = normalize(in_TangentWS);
	vec3 wTangent = normalize(in_NormalWS);
	wTangent = normalize(wTangent - dot(wTangent, wNormal) * wNormal);
	vec3 wBiTangent = cross(wNormal, wTangent);
	mat3 out_TBN = mat3(wTangent,wBiTangent,wNormal);
	
    vec3 normal0 = normalize(texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0);
	vec3 normal = normalize(out_TBN*normal0);
	
    vec4 albedo = texture2D(diffuseMap, in_Coordinate);  //diffusetex  模型贴图
    vec3 specularAO = vec3(1.0,0.5,1.0);  //高光贴图   没有，直接写死

    float occlusion = specularAO.b;
    float intensity = specularAO.r;
    float roughness = specularAO.g;
	vec3 F0 = vec3(0.028);
	float metallic = 0.0;
	
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);

	vec3 light = normalize(in_SpotDirection);
    // Calculate the diffuse and specular lighting:
    vec3 diffuse = vec3(saturate(dot(light, normal)));;
    float specular = intensity * SpecularKSK(normal, light, normalize(in_ViewDirection),1.0-roughness,beckmannTex);   //beckmannTex法线分布函数
    float expFactor = exp(60.0 * ( in_TexDepth - in_OrigDepth ));
    expFactor = clamp(expFactor, 0.0, 1.0);

    // Add the diffuse and specular components:
    color.rgb += (albedo.rgb * diffuse + max(specular,0.0)) * expFactor * mix(in_LightColor,in_TransparentColor.xyz,in_TransparentColor.a) * g_fAttenuation; //BRDF

    color.rgb += SSSSTransmittance(0.6, 0.05, 0.015, 0.02, normal, light,  in_TexDepth, in_OrigDepth);   //透射

    vec4 in_SurfaceColor =  color;

#END_CODE
#END_DEFINE

#SHADER_DEFINE SkinFragmentSpotTransparent

    FUNCTION_INPUT =
    {
		{ WORLDSPACE_VIEWDIRECTION,				LOW,			VEC3,				"in_ViewDirection"},
        { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,		"in_Coordinate" },
        { LIGHT_VERTEX_DIRECTION,		MEDIUM,		VEC3,		"in_LightDirection" },
        { LIGHT_GIVEN_DIRECTION,		MEDIUM,		VEC3,		"in_SpotDirection" },
        { LIGHT_COLOR, 							MEDIUM,		VEC3,		"in_LightColor"},
        { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
        { TEXTURE_BECKMANN,			  NONE,			TEXTURE2D,		"beckmannTex" },
        { TEXTURE_NORMAL,					NONE,			TEXTURE2D,		"normalMap" },
        { AMBIENT_COLOR,		LOW,		VEC3,		"in_Ambient_Light" },
        { WORLDSPACE_DEPTH, 			HIGH,	FLOAT,		"in_TexDepth" },
        { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "in_OrigDepth"},
        { LIGHT_RANGE_INV,				MEDIUM,		FLOAT,		"in_RangeInv" },
        { LIGHT_ATTENUATION,			MEDIUM,		VEC4,		"in_LinghtAtten" },
        { LIGHT_INNER_DIFF_INV,			MEDIUM,		VEC2,		"in_vInner_DiffInv" },
        { WORLDSPACE_NORMAL,         	HIGH,    		VEC3,        	"in_NormalWS" },
		{ WORLDSPACE_TANGENT,   		HIGH, 	 		VEC3,    		"in_TangentWS"},
    }

    FUNCTION_OUTPUT =
    {
			{ ALBEDO_COLOR,							LOW,			VEC4,					"albedo" },
		{ METALLIC_VALUE,						HIGH,			FLOAT,				"metallic" },
		{ ROUGHNESS_VALUE,					HIGH,			FLOAT,				"roughness" },
		{ AO_VALUE,				HIGH,			FLOAT,				"occlusion" },
		{ Base_Reflectivity,						LOW,			VEC3,					"F0"},
        { SURFACE_COLOR,	LOW,	VEC4,	"in_SurfaceColor" },
		{ WORLDSPACE_NORMAL,						LOW,			VEC3,					"normal" },
    }

#SHADER_CODE

    float dis = length( in_LightDirection );
    float disRange = clamp( dis * in_RangeInv, 0.0, 1.0 );
    float g_fAttenuation = (1.0 - disRange ) / ( in_LinghtAtten.x + disRange * in_LinghtAtten.y + disRange * disRange * in_LinghtAtten.z );
    float attenAngle = clamp( 1.0 - ( in_vInner_DiffInv.x - dot(normalize( in_LightDirection ), -in_SpotDirection) ) * in_vInner_DiffInv.y, 0.0, 1.0 );
    g_fAttenuation *= attenAngle;


	vec3 wNormal = normalize(in_NormalWS);
	vec3 wTangent = normalize(in_TangentWS);
	wTangent = normalize(wTangent - dot(wTangent, wNormal) * wNormal);
	vec3 wBiTangent = cross(wNormal, wTangent);
	mat3 out_TBN = mat3(wTangent,wBiTangent,wNormal);
	
    vec3 normal0 = normalize(texture2D(normalMap, in_Coordinate).xyz * 2.0 - 1.0);
	vec3 normal = normalize(out_TBN*normal0);

	
    vec4 albedo = texture2D(diffuseMap, in_Coordinate);  //diffusetex  模型贴图
    vec3 specularAO = vec3(1.0,0.5,1.0);  //高光贴图   没有，直接写死

    float occlusion = specularAO.b;
    float intensity = specularAO.r;
    float roughness = specularAO.g;
	vec3 F0 = vec3(0.028);
	float metallic = 0.0;
	
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);

	vec3 light = normalize(in_SpotDirection);
    // Calculate the diffuse and specular lighting:
    vec3 diffuse = vec3(saturate(dot(light, normal)));;
    float specular = intensity * SpecularKSK(normal, light, normalize(in_ViewDirection), 1.0-roughness,beckmannTex);   //beckmannTex法线分布函数
    float expFactor = exp(60.0 * ( in_TexDepth - in_OrigDepth ));
    expFactor = clamp(expFactor, 0.0, 1.0);

    // Add the diffuse and specular components:
    color.rgb += (albedo.rgb * diffuse + specular) * expFactor * in_LightColor * g_fAttenuation; //BRDF

    color.rgb += SSSSTransmittance(0.6, 0.05, 0.015, 0.02, normal, light,  in_TexDepth, in_OrigDepth);   //透射


    vec4 in_SurfaceColor = color;

#END_CODE
#END_DEFINE


#SHADER_DEFINE SkinShadowTransform

	FUNCTION_INPUT =
	{
    { LIGHT_CAMERA_VIEW,               HIGH, MAT4,   "in_LightCameraViewMatrix"},
    { LIGHT_CAMERA_PROJECTION,         HIGH, MAT4,   "in_LightCameraPorjMatrix"},
    { LIGHT_CAMERA_LINEARPARAM, HIGH,	VEC3,		"in_LightCameraLineDepthParam"},
    { LIGHT_CAMERA_POSITION,    HIGH, VEC3,   "in_LightCameraPosition"},
    { WORLDSPACE_POSITION,		HIGH,	VEC4,		  "in_PositionWS" },
    { WORLDSPACE_NORMAL, 		HIGH,	VEC3,		"in_Normal" },
	}

	FUNCTION_OUTPUT =
	{
    { LIGHTSPACE_COORD,    HIGH, VEC4,    "out_LightCoord"},
    { WORLDSPACE_LIGHTCAMERA_DISTANCE, HIGH, FLOAT, "out_OrigDepth"}
	}

#SHADER_CODE
  const mat4 biasMatrix = mat4(0.5,0.0,0.0,0.0,
                        0.0,0.5,0.0,0.0,
                        0.0,0.0,0.5,0.0,
                        0.5,0.5,0.5,1.0);
    in_Normal = normalize(in_Normal);
    in_PositionWS.xyz = in_PositionWS.xyz - 0.005 * in_Normal;   //需要向内塌陷一段距离，否则会出现锯齿
    vec4 out_LightCoord = in_LightCameraPorjMatrix * in_LightCameraViewMatrix * in_PositionWS;
    vec4 positionCS = in_LightCameraViewMatrix * in_PositionWS;
    out_LightCoord = out_LightCoord / out_LightCoord.w;
    out_LightCoord = biasMatrix * out_LightCoord;
	highp float out_OrigDepth = ( -positionCS.z / positionCS.w - in_LightCameraLineDepthParam.x ) * in_LightCameraLineDepthParam.y;

#END_CODE
#END_DEFINE

