

#DEFPARAMS
#END

#DEFTAG
ShaderName = "Disgauss"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_uBwm;
Texture2D TEXTURE_uHam;
SamplerState uBwm_Sampler;
SamplerState uHam_Sampler;
float2 UNIFORM_uOs;
float UNIFORM_uEfa;
float UNIFORM_uWad;
float UNIFORM_uEds;
float UNIFORM_uVer;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 bad;
    //if (abs(uVer - 2.0) < 0.0001) {
        bad = normalize(decode(TEXTURE_uBwm.Sample(uBwm_Sampler, i.uv)));
    //}
    //else bad = normalize(texture2D(uBwm, vUV).xy);

    float2 dir = ( abs(UNIFORM_uEds) < 0.0001 ) ? float2(bad.y, -bad.x) : bad;
    float2 offset = dir * UNIFORM_uOs;
    
    float3 center = TEXTURE_uHam.Sample(uHam_Sampler, i.uv).rgb;
    float3 result = center;
    float sum = 1.0;
    
    for (int j = 0; j < 6; ++j) {
        float3 c0 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv + float(j) * offset).rgb;
        float3 c1 = TEXTURE_uHam.Sample(uHam_Sampler, i.uv - float(j) * offset).rgb;
        float lc0 = distance(c0, center);
        float lc1 = distance(c1, center);
        float k0 = gauss(float(j), UNIFORM_uEfa) * gauss(lc0, UNIFORM_uWad);
        float k1 = gauss(float(j), UNIFORM_uEfa) * gauss(lc1, UNIFORM_uWad);
        sum += k0 + k1;
        result += c0 * k0 + c1 * k1;
    }

    result /= sum;
    mainColor = float4(result, 1.0);
}
ENDCG
#END
