
#DEFPARAMS
TEXTURE_DIFFUSE = {"TEXTURE_DIFFUSE", TEXTURE2D, "white" },
TEXTURE_TO_COLOR = {"TEXTURE_TO_COLOR", TEXTURE2D, "white" },
TEXTURE_MASK = {"TEXTURE_MASK", TEXTURE2D, "white" },
TEXTURE_LUT = {"TEXTURE_LUT", TEXTURE2D, "white" },
BIRGHTNESS = {"BIRGHTNESS", FLOAT, "1.0"},
BRIGHTNESS_CURVECOEF = {"BRIGHTNESS_CURVECOEF", VEC4, "1.0,1.0,1.0,1.0"},
SATURATION_CURVECOEF = {"SATURATION_CURVECOEF", VEC4, "1.0,1.0,1.0,1.0"},
#END

#DEFTAG
ShaderName = "haircolor_changecolor"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	
	o.vertex = UniformNDC(v.in_Position);
	o.out_Coordinate = v.in_Coordinate.xy;
	return o;
}

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_TO_COLOR;
Texture2D TEXTURE_MASK;
Texture2D TEXTURE_LUT;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_TO_COLOR_Sampler;
SamplerState TEXTURE_MASK_Sampler;
SamplerState TEXTURE_LUT_Sampler;
float BIRGHTNESS;
float4 BRIGHTNESS_CURVECOEF;
float4 SATURATION_CURVECOEF;

float3 rgb2hsv(float3 c)
{
    float4 K = float4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    float4 p = lerp(float4(c.bg, K.wz), float4(c.gb, K.xy), step(c.b, c.g));
    float4 q = lerp(float4(p.xyw, c.r), float4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return float3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

float3 hsv2rgb(float3 c)
{
    float4 K = float4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    float3 p = abs(frac(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * lerp(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float brightadjust(float k0,float k1,float k2, float k3,float x)
{
    float x2 = x * x;
    float x3 = x2 * x;
    return k0 * x3 + k1 * x2 + k2 * x + k3;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#define in_SrcTexture TEXTURE_DIFFUSE
	#define in_ToColorTex TEXTURE_TO_COLOR
	#define in_ColorMask TEXTURE_MASK
	#define in_TextureLUT TEXTURE_LUT

	float2 in_TexCoordinate = i.out_Coordinate;
	float in_Brightness = BIRGHTNESS;
	float4 in_BrightnessCurveCoef = BRIGHTNESS_CURVECOEF;
	float4 in_SaturationCurveCoef = SATURATION_CURVECOEF;

	float4 mask = TEXTURE_MASK.Sample(TEXTURE_MASK_Sampler, float2(in_TexCoordinate.x, in_TexCoordinate.y));
    float4 src_color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, float2(in_TexCoordinate.x, in_TexCoordinate.y));
    float3 src_hsv = rgb2hsv(src_color.xyz);
    //对头发原亮度进行亮度映射
    float final_src_brightness = 0.0;
    /*if (src_hsv.z < 0.5)
      final_src_brightness = in_BrightnessRange.x + (src_hsv.z / 0.5) * (in_BrightnessRange.y - in_BrightnessRange.x);
    else
      final_src_brightness = in_BrightnessRange.y + ((src_hsv.z - 0.5) / 0.5 )* (in_BrightnessRange.z - in_BrightnessRange.y);*/
    //调亮度曲线
    final_src_brightness = brightadjust(in_BrightnessCurveCoef.x,in_BrightnessCurveCoef.y,in_BrightnessCurveCoef.z,in_BrightnessCurveCoef.w,src_hsv.z);
    float4 in_ToColor = TEXTURE_TO_COLOR.Sample(TEXTURE_TO_COLOR_Sampler,in_TexCoordinate);
    float3 dst_hsv = rgb2hsv(in_ToColor.xyz);
    src_hsv = float3(dst_hsv.x,dst_hsv.y,final_src_brightness);  //调整亮度
    float3 dst_rgb = clamp(hsv2rgb(src_hsv),float3(0.0,0.0,0.0), float3(1.0,1.0,1.0));
    dst_hsv = rgb2hsv(dst_rgb);
    //调饱和度曲线
    float saturaion = brightadjust(in_SaturationCurveCoef.x,in_SaturationCurveCoef.y,in_SaturationCurveCoef.z,in_SaturationCurveCoef.w,dst_hsv.y);
    src_hsv = float3(dst_hsv.x,saturaion,dst_hsv.z);

    dst_rgb = clamp(hsv2rgb(src_hsv),float3(0.0,0.0,0.0),float3(1.0,1.0,1.0));
    float maskf = clamp((1.0 - in_ToColor.a) + (1.0 - mask.r),0.0,1.0);
    float3 final_rgb = (src_color.rgb * maskf) + (dst_rgb * (1.0 - maskf));
    mainColor = float4(final_rgb,src_color.a);
}

ENDCG
#END
