local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local mirror = {}
mirror.renderobject = nil;
mirror.material = nil;
mirror.Queue = 200;

function mirror:Initialize(host, size)
  self.UNIFORM_SCALE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SCALE");
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/mirror.material");
  self.material:SetParameter(self.UNIFORM_SCALE, mathfunction.vector1(0.5));
  return self.Queue;
end

function mirror:Resizeview(size)
end

function mirror:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return mirror;

