local Types = require "venuscore.rtti.types"
local VC = require "libvenuscore"
local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BlueDynamicNoDesNode = require "bluecore.base.blue_dynamic_nodes_node"
local BlueprintRef = BlueDynamicNoDesNode:extend();
local BlueRtti = require "bluecore.core.blue_rtti"

BlueprintRef:MemberRegister("refComp", Types.ReferenceType(AE.BlueprintComponent:RTTI()));

function BlueprintRef:new(graph)
  BlueprintRef.super.new(self, graph)
  self.refBlue = nil
end

function BlueprintRef:IsAllowDuplicate()
  return false ;
end

function BlueprintRef:Update(args)
end

function BlueprintRef:GetOutputByIndex(index)
  return self.refBlue -- if nil , compile fail
end

function BlueprintRef:_OnCompile()
  local result = false
  if BlueprintRef.super._OnCompile(self) then
    result = VC.isNil(self.refComp)
    if result then
      self.compileResult = "component is lost";
    else
      result = self.refBlue == nil
      if result then
        self.compileResult = "blueprint is lost";
      end
    end
  else
    result = true
  end
  return not result
end

function BlueprintRef:GetRef()
  return self.refBlue
end

function BlueprintRef:_OnDeserializePost()
  BlueprintRef.super._OnDeserializePost(self)
  if VC.isNil(self.refComp) then
    WARNING("[_OnDeserializePost] BlueNodeRef refComp is nil")
    return
  end

  local blueprint = BU.GetIns(self.refComp)
  if blueprint == nil then
    WARNING("[_OnDeserializePost] BlueNodeRef refBlue is nil")
    return
  end
  self.refBlue = blueprint
  -- 反序列化遇到无效comp 直接用默认的pininfo 编译会失败
  self:_SetupPinInfo(self.refBlue, self.refComp)
end

function BlueprintRef:_SetupPinInfo(blueprint, refComp)
  local clsId = blueprint:GetClassId();
  local node = refComp:GetHostNode();
  local blueprintType = BlueRtti.GetRttiByClsId(clsId)
  local outputPinInfo1 = self.infoTable[BD.PIN_DATA_OUTPUT][1] ;
  outputPinInfo1:ChangeRtti(blueprintType, nil) -- outputpin default is nullable
  outputPinInfo1:ChangeNameAndHint(node.Name, "Reference of "..node.Name)
end

if _KRATOSEDITOR then

function BlueprintRef:_OnBeginCreateEd(comp)
  -- call BlueDynamicNoDesNode to setup instance's infoTable
  BlueprintRef.super._OnBeginCreateEd(self);
  self.refComp = comp
  self.refBlue = BU.GetIns(self.refComp)
  self:_SetupPinInfo(self.refBlue, self.refComp) -- change pinInfo
end

function BlueprintRef:_OnUpdateByEditor()
  self:_OnCompile()
end

function BlueprintRef:SyncEd()
  if self.refBlue ~= nil and not VC.isNil(self.refComp) then
    self:_SetupPinInfo(self.refBlue, self.refComp);
  end
end

end

BlueprintRef:RegisterOutput(1, Types.BlueprintType.INVALID_BLUEPRINT_TYPE, "blueprint", "reference of blueprint");
BlueprintRef:SetFunctionType(BD.REF_BLUEPRINT);
BlueprintRef:SetFunctionName("ref blueprint")

return BlueprintRef