local libvenuscore = require "libvenuscore"

local ArrayItemWrap = libvenuscore.Object:extend("ArrayItemWrap");

function ArrayItemWrap:new()
  self.__typeinfos = {}
  local clazz = getmetatable(self) -- clazz Of ArrayItemWrap
  for k, v in pairs(clazz.__typeinfos) do
    self.__typeinfos[k] = v;
  end
  self.value = nil;
  --  self.value = nil
  -- 如果是nil 会根据序列化数据中的__typename重建 这里完全相信序列化信息 并从中恢复
end

-- 由于value的类型未知 要在创建和反序列化时 由自定义变量或者函数参数 更新进来
function ArrayItemWrap:SetTypeInfo(tinfo)
  tinfo:SetKeyname("value"); -- 用来保证basetype没有设置set和get时 内部生成一个set和get函数
  self.__typeinfos["value"] = tinfo
end

-- 只是返回value字段的 typeinfo
function ArrayItemWrap:GetTypeInfo()
  return self.__typeinfos["value"]
end

function ArrayItemWrap:Set(value)
  self.value = value
end

function ArrayItemWrap:Get()
  return self.value
end

ArrayItemWrap:MemberRegister("value");

return ArrayItemWrap
