local AE = require "apolloengine"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local libvenuscore = require "libvenuscore"
local PluginSystem = require "window.editor.system.pluginsystem"
local Fn = require "functional"
local GetImage = BlueNode:extend();

local likeapp

if not _PLATFORM_WINDOWS then
  likeapp = require "likeapp"
end

---- 游戏运行模式
function GetImage:new(...)
  GetImage.super.new(self, ...)
end

function GetImage:_OnUpdate(args)
  if likeapp then
    local x,y,width,height,ts = likeapp.AI:GetImageCB();
    local te ;
    if ts ~= nil then
      te =  AE.TextureEntity();
      te:PushMetadata(
              AE.TextureBufferMetadata(
                      AE.TextureEntity.TU_READ, 
                      1, 
                      false,
                      AE.TextureEntity.TW_CLAMP_TO_EDGE, -- 需要作为参数配置 ??
                      AE.TextureEntity.TW_CLAMP_TO_EDGE,
                      AE.TextureEntity.TF_NEAREST,
                      AE.TextureEntity.TF_NEAREST,
                      ts));
      te:SetJobType(libvenuscore.IJob.JT_SYNCHRONOUS);
      te:SetKeepSource(true)
      te:CreateResource();
    end
    WARNING(string.format("GetImage, (%d %d), (%d,%d))", x, y, width, height)..", te "..tostring(te));
    return x, y, width, height, te, ts
  else
    local tx = nil
    local pluginList = PluginSystem:GetPluginList()
    for pluginPath, plugin in pairs(pluginList) do
      if plugin:GetName() == "Preview" then
        local inst = plugin:GetInstance()
        tx = inst:GetVideoTexture()
        break
      end
    end
    if tx == nil then
      ERROR("GetImage: failed to get texture")
      return 0, 0, 0, 0, nil, nil ;
    end
    local ts = tx:GetSourceStream()
    if ts == nil then
      ERROR("GetImage: failed to get texture stream")
      return 0, 0, 0, 0, nil, nil ;
    end
    local size = ts:GetSize();
    return 0.5, 0.5, size.mx, size.my, tx, ts ;
  end -- if likeapp
end

---- 编辑器模式

GetImage:RegisterOutput(1, Types.FloatType, "x", "x") -- 归一化
GetImage:RegisterOutput(2, Types.FloatType, "y", "y")
GetImage:RegisterOutput(3, Types.IntType, "width", "宽")
GetImage:RegisterOutput(4, Types.IntType, "height", "高")
GetImage:RegisterOutput(5, AE.TextureEntity:RTTI(), "Texture", "图片纹理");
GetImage:RegisterOutput(6, AE.TextureStream:RTTI(), "Image", "图片");

GetImage:RegisterExecInput(1, "exec", "执行");
GetImage:RegisterExecOutput(1, "exec", "执行");
GetImage:SetFunctionName("Get Image");
GetImage:SetFunctionType(BD.USER_INTERFACE_NODE);

return GetImage;

