


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"


local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"
local SetParameterNode = require "bluecore.setparameternode"

local SetScalarValue = SetParameterNode:extend();
--Unreal Engine: Set Scalar Parameter Value

---- 游戏运行模式
function SetScalarValue:new(...)
  SetScalarValue.super.new(self, ...)
end

function SetScalarValue:_OnUpdate(args)
  
  local paraType = self:GetParameterType(args);
  self:SetParameter(args, paraType, apolloengine.MaterialEntity.VT_FLOAT);
  
end



---- 编辑器模式



SetScalarValue:RegisterInput(1, apolloengine.MaterialEntity:RTTI(), "Material", "材质实体", BlueSelf());
SetScalarValue:RegisterInput(2, Types.StringType, "ParaName", "参数名字", "None");
SetScalarValue:RegisterInput(3, mathfunction.vector1:RTTI(), "ParaValue", "参数值", mathfunction.vector1(1.0));



SetScalarValue:RegisterExecInput(1, "exec", "执行");

SetScalarValue:RegisterExecOutput(1, "exec", "执行");

SetScalarValue:SetFunctionName("SetScalarValue");


return SetScalarValue ;

