


local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mf = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local Types = require "venuscore.rtti.types"

local GetWorldPosition = BlueNode:extend();

---- 游戏运行模式
function GetWorldPosition:new(...)
  GetWorldPosition.super.new(self, ...)
end

function GetWorldPosition:_OnUpdate(args)
  local result = args[1]:GetWorldPosition();
  return result:x(), result:y(), result:z();
end



---- 编辑器模式

GetWorldPosition:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetWorldPosition:RegisterOutput(1, Types.FloatType, "x", "世界x坐标");
GetWorldPosition:RegisterOutput(2, Types.FloatType, "y", "世界y坐标");
GetWorldPosition:RegisterOutput(3, Types.FloatType, "z", "世界z坐标");



GetWorldPosition:SetFunctionName("GetWorldPosition");


return GetWorldPosition ;

