local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local BlueUtility = require "bluecore.blueutility"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectTexture2D = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectTexture2D:new(...)
  SetPostEffectTexture2D.super.new(self, ...)
end

function SetPostEffectTexture2D:_OnUpdate(args)

  local tex = args[3]; 
  local entity = nil;

  if not tex then --连线的输入为空
      self.errorWarning = "nil input texture";
      return;
  elseif type(tex) == "string" then
    local filepath = tex
    --传入路径 根据路径后缀判断是什么类型纹理 加载对应元数据  
    local devresourceType = BlueUtility:GetDevResourceType(filepath) --DEVICE_CAPTURE 或者 LAST_QUEUE
    local extension = filepath:match(".+%.(%w+)$"); --得到后缀
    if extension ~= nil then
      extension = string.lower(extension);
    end
    extension = extension or devresourceType;
    entity = BlueUtility:CreateEntity(filepath, extension);   
  end

  local texture = type(tex) == "string" and entity or tex;

  if texture:RTTI() == apolloengine.RenderTargetEntity:RTTI() then --如果输入为fbo
      local rttex = texture:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0);
      if rttex:GetTextureType() ~= apolloengine.TextureEntity.TT_TEXTURE2D then
        self.errorWarning = "input texture isnt TEXTURE 2D(fbo)";
        return;
      end
  elseif texture:GetTextureType() ~= apolloengine.TextureEntity.TT_TEXTURE2D then
      self.errorWarning = "input texture isnt TEXTURE 2D(tex)";
      return;
  end


 
  args[1]:SetParameter(args[2], texture);
 

end



function SetPostEffectTexture2D:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == apolloengine.TextureEntity:RTTI();
end



SetPostEffectTexture2D:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectTexture2D:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 
SetPostEffectTexture2D:RegisterInput(3, apolloengine.TextureEntity:RTTI(), "ParaValue", "参数值", "DEVICE_CAPTURE");


SetPostEffectTexture2D:RegisterExecInput(1, "exec", "执行");

SetPostEffectTexture2D:RegisterExecOutput(1, "exec", "执行");

SetPostEffectTexture2D:SetFunctionName("SetPostEffectTexture2D");


return SetPostEffectTexture2D ;


