local Config = {};

-- maximum number of different face id
Config.max_face_id = 3;

-- maximum number of liquify lens
Config.max_lens = 6;

local subject = {
    ["human"] = {
        num_lmks = 106,
        size = {400, 600},
        landmarks = {
            {59.595343017578124, 230.440185546875},
            {60.7675048828125, 249.407666015625},  
            {62.975146484375, 268.3905517578125},  
            {66.35065307617188, 287.0700439453125},
            {70.302587890625, 305.4160400390625},
            {74.37022705078125, 323.32861328125},
            {78.18827514648437, 341.21767578125},
            {82.173828125, 359.0614990234375},
            {87.3768310546875, 376.64267578125},
            {94.90874633789062, 393.3079345703125},
            {104.78017578125, 408.6516845703125},
            {116.555078125, 422.5595703125},
            {130.1277099609375, 434.77744140625},
            {145.21368408203125, 445.308544921875},
            {161.73583984375, 453.24814453125},
            {179.5632080078125, 457.4095703125},
            {197.3503662109375, 458.4033203125},
            {214.535205078125, 457.09326171875},
            {231.3990234375, 453.0177734375},
            {247.3376220703125, 445.5728515625},
            {262.0720458984375, 435.60859375},
            {275.420654296875, 423.926708984375},
            {287.1471435546875, 410.4318359375},
            {297.10908203125, 395.3304931640625},
            {304.9416259765625, 378.7947998046875},
            {310.523291015625, 361.4008544921875},
            {315.087158203125, 343.738720703125},
            {319.4508544921875, 326.056591796875},
            {324.0349853515625, 308.3719970703125},
            {328.57880859375, 290.421533203125},
            {332.208056640625, 272.1742431640625},
            {334.83544921875, 253.642431640625},
            {336.5367431640625, 234.9862548828125},
            {83.854345703125, 212.818603515625},
            {101.5666748046875, 199.971875},
            {123.276513671875, 194.770751953125},
            {146.1520263671875, 197.0900146484375},
            {168.5423095703125, 202.0673095703125},
            {232.615380859375, 204.63916015625},
            {254.7142578125, 198.1541748046875},
            {277.6051513671875, 194.7294677734375},
            {299.577978515625, 200.022412109375},
            {316.5709716796875, 214.352392578125},
            {199.44747314453124, 243.105712890625},
            {200.5196044921875, 266.1859375},
            {199.9833251953125, 290.83955078125},
            {199.44461669921876, 315.4953125},
            {169.46068115234374, 334.1952880859375},
            {184.28321533203126, 337.232470703125},
            {199.3375244140625, 339.462890625},
            {214.150439453125, 337.6489990234375},
            {228.621533203125, 334.854833984375},
            {107.2004150390625, 239.88359375},
            {123.331201171875, 230.544287109375},
            {153.3817138671875, 236.190380859375},
            {164.104638671875, 251.266650390625},
            {148.2061279296875, 251.9644287109375},
            {121.19461669921876, 247.5124755859375},
            {236.874609375, 251.706884765625},
            {248.3460205078125, 237.197021484375},
            {278.432666015625, 232.4261962890625},
            {292.7385498046875, 243.641162109375},
            {279.5498291015625, 252.13525390625},
            {252.505078125, 254.6676025390625},
            {104.73978271484376, 209.3105712890625},
            {125.883837890625, 207.8484375},
            {147.0370361328125, 210.00224609375},
            {167.79453125, 213.5187744140625},
            {234.2953369140625, 216.18017578125},
            {254.655712890625, 211.21796875},
            {275.49677734375, 207.8763427734375},
            {296.36630859375, 209.1658203125},
            {138.84454345703125, 230.822607421875},
            {134.629052734375, 250.4051513671875},
            {136.7367919921875, 240.6138671875},
            {263.044140625, 232.08544921875},
            {266.1314453125, 254.366259765625},
            {264.58779296875, 243.2258544921875},
            {181.49532470703124, 246.2052734375},
            {217.536279296875, 246.9002197265625},
            {170.66683349609374, 303.6352783203125},
            {228.4418701171875, 304.6604736328125},
            {161.14412841796874, 321.7009521484375},
            {237.1046142578125, 322.937353515625},
            {148.38494873046875, 381.06708984375},
            {166.81068115234376, 371.526611328125},
            {187.05322265625, 364.1112548828125},
            {199.84783935546875, 367.666796875},
            {212.3142578125, 364.149755859375},
            {231.8413330078125, 371.2712158203125},
            {249.6570068359375, 380.526416015625},
            {229.454833984375, 401.31533203125},
            {215.91220703125, 408.562255859375},
            {200.0989013671875, 410.73740234375},
            {184.0730712890625, 408.249462890625},
            {170.29852294921875, 400.8240966796875},
            {154.79781494140624, 381.7812744140625},
            {183.05465087890624, 382.0031494140625},
            {199.8662109375, 383.395947265625},
            {216.1588134765625, 382.1485107421875},
            {243.570458984375, 381.283984375},
            {216.0559814453125, 382.2376220703125},
            {199.5485107421875, 383.6980712890625},
            {182.811767578125, 382.240185546875},
            {136.7367919921875, 240.6138671875},
            {264.58779296875, 243.2258544921875}
        },
        triangles = {
            {0,33,52}, {1,0,52}, {2,1,52}, {4,2,52}, {4,52,57}, {4,57,80}, {57,56,80}, {56,45,80}, {56,44,45}, {56,55,44},
            {55,43,44}, {55,67,43}, {54,67,55}, {54,66,67}, {54,65,66}, {53,65,54}, {64,65,53}, {52,64,53}, {33,64,52}, {33,34,64},
            {34,65,64}, {34,35,65}, {35,66,65}, {35,36,66}, {36,67,66}, {36,37,67}, {37,43,67}, {80,45,46}, {82,80,46}, {4,80,82},
            {4,82,6}, {6,82,8}, {8,82,84}, {8,84,10}, {10,84,12}, {12,84,95}, {12,95,13}, {13,95,94}, {13,94,14}, {14,94,93},
            {14,93,16}, {82,46,47}, {47,46,48}, {48,46,49}, {84,82,85}, {82,47,85}, {85,47,86}, {47,48,86}, {86,48,87}, {48,49,87},
            {84,85,96}, {96,85,97}, {85,86,97}, {97,86,98}, {98,86,87}, {96,97,103}, {103,97,98}, {103,98,102}, {84,96,95}, {96,103,95},
            {95,103,94}, {94,103,102}, {94,102,93}, {52,53,104}, {53,54,104}, {104,54,55}, {104,55,56}, {57,104,56}, {52,104,57}, {61,42,32},
            {61,32,31}, {61,31,30}, {61,30,28}, {62,61,28}, {81,62,28}, {81,63,62}, {45,63,81}, {45,44,63}, {45,58,63}, {44,43,58},
            {43,68,58}, {58,68,59}, {68,69,59}, {59,69,70}, {59,70,60}, {60,70,71}, {60,71,61}, {61,71,42}, {71,41,42}, {70,41,71},
            {70,40,41}, {69,40,70}, {69,39,40}, {68,39,69}, {68,38,39}, {43,38,68}, {46,45,81}, {46,81,83}, {81,28,83}, {83,28,26},
            {83,26,24}, {83,24,90}, {90,24,22}, {90,22,20}, {91,90,20}, {91,20,19}, {92,91,19}, {18,92,19}, {93,92,18}, {16,93,18},
            {46,83,51}, {46,51,50}, {46,50,49}, {89,83,90}, {51,83,89}, {88,51,89}, {88,50,51}, {87,50,88}, {87,49,50}, {89,90,100},
            {99,89,100}, {99,88,89}, {98,88,99}, {98,87,88}, {99,100,101}, {98,99,101}, {98,101,102}, {91,100,90}, {101,100,91}, {92,101,91},
            {102,101,92}, {93,102,92}, {105,60,61}, {59,60,105}, {58,59,105}, {58,105,63}, {63,105,62}, {105,61,62}, {37,38,43}
        },
        point_mirror = {
            [0] = 32, [1]=31, [2]=30, [3]=29, [4]=28, [5]=27, [6]=26, [7]=25, [8]=24, [9]=23,
            [10] = 22, [11]=21, [12]=20, [13]=19, [14]=18, [15]=17, [16]=16, [17]=15, [18]=14, [19]=13,
            [20] = 12, [21]=11, [22]=10, [23]=9, [24]=8, [25]=7, [26]=6, [27]=5, [28]=4, [29]=3,
            [30] = 2, [31]=1, [32]=0, [33]=42, [34]=41, [35]=40, [36]=39, [37]=38, [38]=37, [39]=36,
            [40] = 35, [41]=34, [42]=33, [43]=43, [44]=44, [45]=45, [46]=46, [47]=51, [48]=50, [49]=49,
            [50] = 48, [51]=47, [52]=61, [53]=60, [54]=59, [55]=58, [56]=63, [57]=62, [58]=55, [59]=54,
            [60] = 53, [61]=52, [62]=57, [63]=56, [64]=71, [65]=70, [66]=69, [67]=68, [68]=67, [69]=66,
            [70] = 65, [71]=64, [72]=75, [73]=76, [74]=77, [75]=72, [76]=73, [77]=74, [78]=79, [79]=78,
            [80] = 81, [81]=80, [82]=83, [83]=82, [84]=90, [85]=89, [86]=88, [87]=87, [88]=86, [89]=85,
            [90] = 84, [91]=95, [92]=94, [93]=93, [94]=92, [95]=91, [96]=100, [97]=99, [98]=98, [99]=97,
            [100] = 96, [101]=103, [102]=102, [103]=101, [104]=105, [105]=104
        }
    },
    ["cat"] = {
        num_lmks = 32,
        size = {506, 512},
        landmarks = {
            {251, 66}, {350, 85}, {447, 164}, {457, 262},
            {425, 347}, {357, 403}, {257, 431}, {158, 406},
            {86, 354}, {48, 267}, {57, 168}, {149, 87},
            {140, 226}, {177, 212}, {205, 243}, 
            {168, 257}, {173, 234}, {302, 243},
            {329, 213}, {365, 227}, {339, 258}, {333, 234},
            {222, 307}, {253, 294}, {285, 308}, {254, 333},
            {218, 375}, {255, 346}, {290, 374}, {255, 361},
            {14, 2}, {477, 0}
        },
        triangles = {
            {0, 1, 17}, {1, 18, 17}, {1, 2, 18}, {1, 31, 2},
            {2, 19, 18}, {2, 3, 19}, {19, 3, 20},
            {18, 19, 21}, {21, 19, 20}, {21, 20, 17}, {18, 21, 17},
            {3, 4, 20}, {20, 4, 24}, {24, 4, 5}, {17, 20, 24},
            {17, 24, 23}, {24, 5, 28}, {28, 5, 6}, {29, 28, 6},
            {24, 28, 27}, {25, 24, 27}, {27, 28, 29}, {23, 24, 25},
            {0, 17, 14}, {14, 17, 23},
            {0, 14, 11}, {11, 14, 13}, {11, 13, 10}, {30, 11, 10},
            {10, 13, 12}, {10, 12, 9}, {12, 15, 9},
            {12, 13, 16}, {13, 14, 16}, {16, 14, 15}, {12, 16, 15},
            {9, 15, 8}, {8, 15, 22}, {15, 14, 22}, {14, 23, 22},
            {8, 22, 7}, {7, 22, 26}, {7, 26, 6}, {26, 29, 6},
            {22, 23, 25}, {22, 25, 27}, {22, 27, 26}, {26, 27, 29}
        },
        point_mirror = {
            [0]=0, [1]=11, [2]=10, [3]=9, [4]=8, [5]=7, [6]=6, [7]=5, [8]=4, [9]=3,
            [10]=2, [11]=1, [12]=19, [13]=18, [14]=17, [15]=20, [16]=21, [17]=14, [18]=13, [19]=12,
            [20]=15, [21]=16, [22]=24, [23]=23, [24]=22, [25]=25, [26]=28, [27]=27, [28]=26, [29]=29,
            [30]=31, [31]=30
        }
    }
}

Config.subject = subject;

return Config;