require "utility"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local tonemappingACES = {}

tonemappingACES.renderObject = nil;
tonemappingACES.queue = 1000;

tonemappingACES.A = 0;
tonemappingACES.B = 0;
tonemappingACES.C = 0;
tonemappingACES.D = 0;
tonemappingACES.E = 0;


function tonemappingACES:Initialize(host, size)
  
  self.A          = mathfunction.vector1(278.5085);
  self.B          = mathfunction.vector1(10.77772);
  self.C          = mathfunction.vector1(293.6045);
  self.D          = mathfunction.vector1(88.7122);
  self.E          = mathfunction.vector1(80.6889);
  
  self._MainTex   = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_MainTex");
  self._A         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_A");
  self._B         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_B");
  self._C         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_C");
  self._D         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_D");
  self._E         = apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"_E");

  self.material   = host:CreateMaterial("comm:documents/shaders/posteffect/tonemappingACES.material");
  -- default create a quad mesh object
  self.renderObj  = host:CreateRenderObject();
  
  self:UpdateParameters();
 
  host:RegisterScriptParameter(self, "A");
  host:RegisterScriptParameter(self, "B");
  host:RegisterScriptParameter(self, "C");
  host:RegisterScriptParameter(self, "D");
  host:RegisterScriptParameter(self, "E");
  return self.queue;
end

function tonemappingACES:Resizeview(size)

end

function tonemappingACES:Process(context, Original, Scene, Output)

  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  
  self.material:SetParameter(
          self._MainTex,
          Scene:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));
        
  self:UpdateParameters();
  context:Draw(self.renderObj, self.material);

  context:EndRenderPass();
end

function tonemappingACES:UpdateParameters()

    local A = self.A;
    local B = self.B;
    local C = self.C;
    local D = self.D;
    local E = self.E;
    
    self.material:SetParameter(self._A, A);
    self.material:SetParameter(self._B, B);
    self.material:SetParameter(self._C, C);
    self.material:SetParameter(self._D, D);
    self.material:SetParameter(self._E, E);
end

return tonemappingACES;