local apollocore = require "apollocore"
local venuscore = require "venuscore"
local BundleSystem = require "venuscore.bundle.bundlesystem"


local _fDeleteComponent = apollocore.Node.DeleteComponent;
local _fSetHostPrefabPath = apollocore.Node.SetHostPrefabPath;
local _fSetPrefabPath = apollocore.Node.SetPrefabPath;

function apollocore.Node:OnDeserializeFinished()
  local components = self.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.DeserializeFinishedDelegates[typename] then  
      local func = venuscore.BundleSystem.DeserializeFinishedDelegates[typename];
      func(comp,nil);
    end
    comp:Awake();  --统一调用Component的Awake
    local instances = comp.Instances;
    if instances then
      for key,value in pairs(instances) do
        value:Awake(); --ScripComponent 脚本的Awake
      end
    end
  end
end

function apollocore.Node:OnSerializeStarted()
  local components = self.Components;
  for comType, comp in pairs(components) do
    local typename = comp:GetTypeName();
    if venuscore.BundleSystem.SerializeStartedDelegates[typename] then  
      local func = venuscore.BundleSystem.SerializeStartedDelegates[typename];
      func(comp,nil);
    end
  end 
end

function apollocore.Node:Start()
  local components = self.Components;
  for comType, com in pairs(components) do
    com:Start();
    --测试ScriptComponent的Update
    local instance = com.Instances
    if instance then
      for scrKey,scrValue in pairs(instance) do
        if scrValue then
          scrValue:Start();
        end
      end
    end
  end
end

function apollocore.Node:Update(def)
  local components = self.Components;
  for comType, com in pairs(components) do
    com:Update(def);
    --测试ScriptComponent的Update
    local instance = com.Instances
    if instance then
      for scrKey,scrValue in pairs(instance) do
        if scrValue then
          scrValue:Update(def);
        end
      end
    end
  end
end

function apollocore.Node:LateUpdate(def)
  local components = self.Components;
  if components then
    for comType, com in pairs(components) do
      com:LateUpdate(def);
      local instance = com.Instances
      if instance then
        for scrKey,scrValue in pairs(instance) do
          if scrValue then
            scrValue:LateUpdate(def);
          end
        end
      end
    end
  end
end

function apollocore.Node:DeleteComponent(compType)
  local com = self:GetComponent(compType);
  if com then
    com:Destroy();
  end
  _fDeleteComponent(self,compType);
end

--PrefabPath只能是prefab(或实例)顶节点才有值 其余都是空字符串
--HostPrefabPath是prefab(或实例)节点都需要有值
--在脚本封装一层以免反序列化的时候重复递归设置
function apollocore.Node:SetPrefabPathInEdSc(path) --拖到assets窗口的node调用该函数
  _fSetPrefabPath(self, path);
  --self:SetHostPrefabPathInEdSc(path, true);--递归子节点调用
  _fSetHostPrefabPath(self, path);
  local childNodeSet = self.ChildNodes;
  for _,childNode in pairs(childNodeSet) do
    childNode:SetHostPrefabPathInEdSc(path);
  end
end

function apollocore.Node:SetHostPrefabPathInEdSc(path)
  _fSetHostPrefabPath(self, path);
  --prefab实例再次拖到assets需要刷新PrefabPath(有可能prefabA实例嵌套prefabB实例然后拖到assets目录下生成新prefabC)
  _fSetPrefabPath(self, "");
  local childNodeSet = self.ChildNodes;
  for _,childNode in pairs(childNodeSet) do
    childNode:SetHostPrefabPathInEdSc(path);
  end
end

--克隆节点及其子节点
function apollocore.Node:Clone()
  --序列化到内存
  local memTable = BundleSystem:SerializeToMemoryTable(self);
  --反序列化
  local scene = self:GetHostScene();
  local _,nodes = BundleSystem:DeserializeFromMemoryTable(memTable, BundleSystem.DeserializeMode.Prefab,scene);
  --因为现在同级别的Node不允许同名，所以这里需要给反序列化出的根节点改名<originName+ "_Clone">
  if #nodes > 0 then
    local rootNode = nodes[#nodes];
    local originName = rootNode:GetName();
    local newName = originName .. "_Clone";
    rootNode:SetName(newName);
  end
  return nodes;
end



return apollocore.Node;