
#DEFPARAMS
_MainTex = { "main Color", TEXTURE2D, "maintex" },
_Threshold = { "threshold", FLOAT, "0.5" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Threshold"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D _MainTex;
SamplerState _MainSampler;
float    _Threshold;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#ifdef POST_EFFECT_ALPHA_OFF
		float3 color = _MainTex.Sample(_MainSampler,i.uv).rgb;
		float mean = (color.r + color.g + color.b) / 3.0;
		float3 res = mean < _Threshold ? float3(0.0,0.0,0.0) : float3(1.0,1.0,1.0);
		mainColor = float4(res,1.0);
	#elif POST_EFFECT_ALPHA_ON
		float4 color = _MainTex.Sample(_MainSampler,i.uv);
		float mean = (color.r + color.g + color.b) / 3.0;
		float3 res = mean < _Threshold ? float3(0.0,0.0,0.0) : float3(1.0,1.0,1.0);
		mainColor = float4(res, color.a);
	#endif
}
ENDCG
#END
