#pragma once

int rand(float x) { return (int)((1.0 + frac(sin(x) * 43758.5453)) * 64.0);}

inline float Fade(float t)
{
  return t * t * t * (t * (t * 6 - 15) + 10);
}

// Grad 1 2 3 d
inline float Grad(int hash, float x)
{
  return sign(frac((float)hash / 2.0) - 0.1) * -x;
}

inline float Grad(int hash, float x, float y)
{
  return sign(frac((float)hash / 2.0) - 0.1) * (y - x);
}

inline float Grad(int hash, float x, float y, float z)
{
  int h = hash % 16;
  float u = h < 8 ? x : y;
  float v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
  return sign(frac((float)hash / 2.0) - 0.1) * (v - u);;
}

// Noise 1 2 3 D
inline float Noise(float x)
{
  int X = (int)floor(x) % 128;
  x = frac(x);
  float u = Fade(x);
  return lerp(Grad(rand(X), x, u), Grad(rand(X + 1), x - 1), u) * 2;
}

inline float Noise(float x, float y)
{
  int X = (int)floor(x) % 128;
  int Y = (int)floor(y) % 128;
  x = frac(x);
  y = frac(y);
  float u = Fade(x);
  float v = Fade(y);
  int A = (rand(X) + Y) % 128;
  int B = (rand(X + 1) + Y) % 128;
  return lerp(lerp(Grad(rand(A), x, y), Grad(rand(B), x - 1, y), u),lerp(Grad(rand(A + 1), x, y - 1), Grad(rand(B + 1), x - 1, y - 1), u), v);
}

inline float Noise(float x, float y, float z)
{
  int X = (int)floor(x) % 128;
  int Y = (int)floor(y) % 128;
  int Z = (int)floor(z) % 128;
  x = frac(x);
  y = frac(y);
  z = frac(z);
  float u = Fade(x);
  float v = Fade(y);
  float w = Fade(z);
  int A = (rand(X) + Y) % 128;
  int B = (rand(X + 1) + Y) % 128;
  int AA = (rand(A) + Z) % 128;
  int BA = (rand(B) + Z) % 128;
  int AB = (rand(A + 1) + Z) % 128;
  int BB = (rand(B + 1) + Z) % 128;
  return lerp(lerp(lerp(Grad(rand(AA), x, y, z), Grad(rand(BA), x - 1, y, z), u),
              lerp(Grad(rand(AB), x, y - 1, z), Grad(rand(BB), x - 1, y - 1, z), u),
              v),
              lerp(lerp(Grad(rand(AA + 1), x, y, z - 1), Grad(rand(BA + 1), x - 1, y, z - 1), u),
              lerp(Grad(rand(AB + 1), x, y - 1, z - 1), Grad(rand(BB + 1), x - 1, y - 1, z - 1), u),
              v),w);
}
			
// Fuction 1 2 3 D
inline float PerlinNoise(float vec, float3 paras)
{
  float total = 0.0;
  for (int i = 0; i < paras.z; i++)
  {
    total += Noise(vec.x * paras.y) * paras.x;
  }
  return total;
}

inline float PerlinNoise(float2 vec, float3 paras)
{
  float total = 0.0;
  for (int i = 0; i < paras.z; i++)
  {
    vec *= paras.y;
    total += Noise(vec.x, vec.y) * paras.x;
    paras.xy *= float2(0.5, 2.0);
  }
  return total;
}

inline float PerlinNoise(float3 vec, float3 paras)
{
  float total = 0.0;
  for (int i = 0; i < paras.z; i++)
  {
    vec *= paras.y;
    total += Noise(vec.x, vec.y, vec.z) * paras.x;
    paras.xy *= float2(0.5, 2.0);
  }
  return total;
}