//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in 
//	all copies or substantial portions of the Software. And the logo of 
//	Bohge Engine shall be displayed full screen for more than 3 seconds 
//	when the software is started. Copyright holders are allowed to develop 
//	game edit based on Bohge Engine, The edit must be released under the MIT 
//	open source license if it is going to be published. In no event shall 
//	copyright holders be prohibited from using any code of Bohge Engine 
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////
//#include "functions/helperfunc.function"
//#include "functions/noise4d.function"
#SHADER_DEFINE EmitterStertch

	FUNCTION_INPUT = 
	{
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

	FUNCTION_OUTPUT = 
	{
    { PARTICLE_OFFEET,		MEDIUM,	VEC3,	"out_Offset" },
	}

#SHADER_CODE
 
  float emittersize1 = in_Size_Distrubance_Stretch.x;
  vec2 speed = (in_WorldRotation * in_Speed_Borntime.xyz).xy;  
  vec2 speedNormlized = normalize(speed.xy + vec2(0.000001,0.000001));   
  
  float stretch = in_Size_Distrubance_Stretch.z;
  
  //vec3 out_Offset = vec3(in_Offset.xy,0.0) * emittersize1 * in_GlobalScale;
  //out_Offset += (speedNormlized * stretch);
  
  mat2 stretchrotation = mat2(-speedNormlized.y,-speedNormlized.x,
                        speedNormlized.x,-speedNormlized.y); 
  vec2 offsetforstretch = (vec3(in_Offset.xy,0.0) * emittersize1 * in_GlobalScale).xy;
  

  offsetforstretch.y = offsetforstretch.y - emittersize1;
  float stretch_ratio = stretch;
  offsetforstretch.y *= stretch_ratio;
  offsetforstretch.y = offsetforstretch.y + emittersize1;
  offsetforstretch = offsetforstretch * stretchrotation;
  vec3 out_Offset = vec3(offsetforstretch,0);



#END_CODE
#END_DEFINE

#SHADER_DEFINE EmitterStertchAlongSpeedWorldSpace

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
	{ WORLD_POSITION,           HIGH,   VEC3,       "in_WorldPosition"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { CAMERA_WORLDDIRECTION, HIGH, VEC3, "in_WorldLoookDir"},
    { CAMERA_WORLDPOSITION,HIGH,VEC3, "in_WorldCamPos"},
    { LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

  FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
vec4 out_Position;
//首先转到Z轴，因为下面的shader都是基于Z方向计算的，目前初始方向是Y轴
//vector3f tp = ((m_Result + (m_Direction.NormalizeSelf() * 2.0)) - pos) * m_rpTransform->GetWorldRotation().Inverse();
vec3 localPos = vec3(in_Center - in_WorldPosition);
mat3 worldRotInv = mat3(
    vec3(in_WorldRotation[0].x, in_WorldRotation[1].x, in_WorldRotation[2].x),
    vec3(in_WorldRotation[0].y, in_WorldRotation[1].y, in_WorldRotation[2].y),
    vec3(in_WorldRotation[0].z, in_WorldRotation[1].z, in_WorldRotation[2].z));
out_Position = vec4(worldRotInv * localPos,1.0);
out_Position = vec4(0.0,0.0,out_Position.y,1.0);
out_Position = in_Transfrom * out_Position;
//out_Position  = in_Transfrom * vec4( in_Center, 1.0);
vec3 worldViewDir = (out_Position.xyz - in_WorldCamPos);
worldViewDir = normalize(worldViewDir);
float stretch = in_Size_Distrubance_Stretch.z;
float emittersize1 = in_Size_Distrubance_Stretch.x;
vec3 speed = (in_WorldRotation * vec3(0.0,0.0,1.0));
//vec3 speed = in_Speed_Borntime.xyz;
vec3 speedNormlized = normalize(speed);
//float project = abs(dot(normalize(-in_WorldLoookDir),speedNormlized));


vec3 cameraRightInWorldspace = vec3(in_View[0][0], in_View[1][0], in_View[2][0]);
vec3 cameraUpInWorldspace = normalize(vec3(in_View[0][1], in_View[1][1], in_View[2][1]));
//速度方向和相机up方向之间做个插值
//speedNormlized = normalize(mix(speedNormlized,cameraUpInWorldspace,pow(project,1000.0)));
//stretch = mix(stretch,1.0,pow(project,1000.0));
//vec3 stretchX = cross(in_WorldLoookDir, speedNormlized);
//stretchX = normalize(stretchX);

//float stepV = step(0.9997,project);
//speedNormlized = speedNormlized * (1.0 - stepV) + cameraUpInWorldspace * stepV;
//stretch = stretch * (1.0 - stepV) + stepV;
//speedNormlized = normalize(speedNormlized);
vec3 stretchX = cross(worldViewDir, speedNormlized);
stretchX = normalize(stretchX);



out_Position.xyz += (speedNormlized * stretch * emittersize1 * in_Offset.y);
out_Position.xyz += (stretchX * emittersize1 * in_Offset.x);
out_Position = in_View * out_Position;	
out_Position = in_Porjection * out_Position;
  

#END_CODE
#END_DEFINE


#SHADER_DEFINE EmitterStertchAlongSpeedScreenSpace

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
    { WORLD_POSITION,		HIGH,	VEC3,		"in_WorldPosition" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

  FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
    { SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
	vec4 out_Position = in_Transfrom * vec4( in_Center, 1.0);
  out_Position = in_View * out_Position;
  
  vec4 positionscreen = in_Porjection * in_View * vec4(in_WorldPosition, 1.0);
  positionscreen.xy /= positionscreen.w;
  
  float stretch = in_Size_Distrubance_Stretch.z;
  vec2 offset = in_Offset * emittersize * in_GlobalScale.xy;  
  vec4 speedScreenSpace = in_Transfrom * vec4(in_Speed_Borntime.xyz, 1.0);
  speedScreenSpace = (in_Porjection * in_View * speedScreenSpace);
  speedScreenSpace.xy /= speedScreenSpace.w;
  speedScreenSpace.xy -= positionscreen.xy;

  vec2 speedScreenSpacedir = normalize(speedScreenSpace.xy);
  mat2 stretchrotation = mat2(-speedScreenSpacedir.y,-speedScreenSpacedir.x,
                        speedScreenSpacedir.x,-speedScreenSpacedir.y);                        

  //offset.y += speedScreenSpace.y * stretch * in_Offset.y * 0.01;
  offset.y *= stretch;
  offset *= stretchrotation;
  float flip = dot( normalize(offset), speedScreenSpacedir);
  flip /= abs(flip);
  //offset.xy += speedScreenSpacedir.xy * stretch * flip * 0.01;

	out_Position.xy += offset;
  
  out_Position = in_Porjection * out_Position;
  //vec4 out_ParticleColor = vec4( speedScreenSpacedir * 0.5 + 0.5, 0.0, 1.0);
  //vec4 out_ParticleColor = vec4( in_Speed_Borntime.xyz, 1.0);
#END_CODE
#END_DEFINE

#SHADER_DEFINE EmitterStertchAlongSpeed_1

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

  FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
float stretch = in_Size_Distrubance_Stretch.z;
float emittersize1 = in_Size_Distrubance_Stretch.x;
vec3 speed = (in_WorldRotation * in_Speed_Borntime.xyz);  
vec3 speedNormlized = normalize(speed.xyz);   
vec3 cameraRightInWorldspace = vec3(in_View[0][0], in_View[1][0], in_View[2][0]);
vec3 cameraUpInWorldspace = vec3(0.0, 1.0, 0.0);
vec3 cameraLookInWorldSpace = cross(cameraRightInWorldspace,cameraUpInWorldspace);
vec3 stretchX = cross(cameraLookInWorldSpace,speedNormlized);
stretchX = normalize(stretchX);

//
vec4 out_Position;
out_Position  = in_Transfrom * vec4( in_Center, 1.0);

out_Position += (speedNormlized * stretch * emittersize1 * in_Offset.y);
out_Position += (stretchX * emittersize1 * in_Offset.x);
out_Position = in_View * out_Position;	
out_Position = in_Porjection * out_Position;
  

#END_CODE
#END_DEFINE

#SHADER_DEFINE EmitterStertchAlongSpeedViewSpace

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { CAMERA_WORLDDIRECTION, HIGH, VEC3, "in_WorldLoookDir"},
    { LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

  FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
float stretch = in_Size_Distrubance_Stretch.z;
float emittersize1 = in_Size_Distrubance_Stretch.x;
vec3 speedViewSpace = (in_View * vec4(in_WorldRotation * in_Speed_Borntime.xyz,0.0)).xyz;
speedViewSpace = normalize(speedViewSpace);

vec3 out_Offset = vec3(in_Offset,0.0);
out_Offset = out_Offset * emittersize1 * in_GlobalScale;

vec4 out_Position;
out_Position  = in_Transfrom * vec4( in_Center, 1.0);
out_Position = in_View * out_Position;	
out_Offset += dot(out_Offset.xyz,speedViewSpace) * speedViewSpace * stretch;
out_Position.xyz += out_Offset;
//out_Position.xyz += dot(out_Position.xyz,speedViewSpace) * speedViewSpace * 2;
out_Position = in_Porjection * out_Position;

#END_CODE
#END_DEFINE


#SHADER_DEFINE EmitterStertchAlongSpeedWorldSpaceRotation

	FUNCTION_INPUT = 
	{
    { LOCALWORLD_TRANSFORM,		HIGH,	MAT4,		"in_Transfrom" },
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
		{ CAMERA_PROJECTION,		HIGH,	MAT4,		"in_Porjection" },
		{ CAMERA_VIEW,				HIGH,	MAT4,		"in_View" },
    { CAMERA_WORLDDIRECTION, HIGH, VEC3, "in_WorldLoookDir"},
    { LOCALSPACE_POSITION, 		HIGH,	VEC3,		"in_Center" },
    { ATTRIBUTE_COORDNATE2, HIGH, VEC4, "in_Size_Distrubance_Stretch"},
    { LOCALWORLD_ROTATION,		HIGH,	MAT3,		"in_WorldRotation" },
    { ATTRIBUTE_COORDNATE3,			MEDIUM,	VEC2,		"in_Offset" },
    { ATTRIBUTE_NORMAL, HIGH, VEC4, "in_Speed_Borntime"},
    { PARTICLE_GLOBAL_SCALE,    HIGH, VEC3,   "in_GlobalScale" },
	}

  FUNCTION_OUTPUT = 
	{
		{ SCREENSPACE_POSITION, 	HIGH,	VEC4,		"out_Position" },
	}

#SHADER_CODE
float stretch = in_Size_Distrubance_Stretch.z;
float emittersize1 = in_Size_Distrubance_Stretch.x;
vec3 speed = (in_WorldRotation * in_Speed_Borntime.xyz);
vec3 speedNormlized = normalize(speed);
vec3 cameraRightInWorldspace = vec3(in_View[0][0], in_View[1][0], in_View[2][0]);
vec3 cameraUpInWorldspace = vec3(in_View[0][1], in_View[1][1], in_View[2][1]);
vec3 stretchX = cross(in_WorldLoookDir, speedNormlized);
stretchX = normalize(stretchX);
vec3 

//rotation matrix


float stepV = step(0.986,project);
speedNormlized = speedNormlized * (1.0 - stepV) + cameraUpInWorldspace * stepV;
stretch = stretch * (1.0 - stepV) + stepV;
speedNormlized = normalize(speedNormlized);
vec3 stretchX = cross(in_WorldLoookDir, speedNormlized);
stretchX = normalize(stretchX);

vec4 out_Position;
out_Position  = in_Transfrom * vec4( in_Center, 1.0);

out_Position.xyz += (speedNormlized * stretch * emittersize1 * in_Offset.y);
out_Position.xyz += (stretchX * emittersize1 * in_Offset.x);
out_Position = in_View * out_Position;	
out_Position = in_Porjection * out_Position;
  

#END_CODE
#END_DEFINE