#DEFPARAMS
#END

#DEFTAG
ShaderName = "hair_depth_resolve"
RenderQueue = "Transparent"
#END

#DEFPASS Hair_Depth_Resolve
COLOR_MASK   = COLOR_NONE
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"



struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};


RWTexture2D<uint> HAIR_THIRDLAYER_DEPTH : register(u1);

v2f vert(appdata v)
{
    v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}


void frag(in v2f v, out float depth : SV_Depth)
{
    int2 vScreenAddress = int2(v.vertex.xy);
    uint uDepth = HAIR_THIRDLAYER_DEPTH[uint2(vScreenAddress)];

	depth = asfloat(uDepth);
}
ENDCG
#END
