#DEFPARAMS
UNIFORM_DEBUGCONE = {"UNIFORM_DEBUGCONE", VEC2, "0.0,0.0"},
COLOR = { "COLOR", VEC3, "0.2, 0.9, 0.2" },
#END

#DEFTAG
ShaderName = "DebugCone"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

float2 UNIFORM_DEBUGCONE;
float3 COLOR;

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	float4 in_Position = v.vertex;
    float2 in_ConeTrans = UNIFORM_DEBUGCONE;
    float4x4 in_Transfrom = LOCALWORLD_TRANSFORM;
    float4x4 in_ViewPorj = CAMERA_VIEWPROJ;
    float4 out_PositionTemp = float4(in_Position.x * in_ConeTrans.y, in_Position.y, in_Position.z * in_ConeTrans.y, 1.0);
    float4 out_PositionUD = float4(out_PositionTemp.x, out_PositionTemp.y * in_ConeTrans.x * 0.5, out_PositionTemp.z, 1.0);
    float4 out_PositionWS = mul(out_PositionUD, in_Transfrom);
    float4 out_Position = mul(out_PositionWS, in_ViewPorj);
	o.vertex = UniformNDC(out_Position);
	o.uv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    mainColor = float4(COLOR, 1.0);
}
ENDCG
#END