
#DEFPARAMS
TEXTURE_DIFFUSE = { "Base Texture", TEXTURE2D, "basetex" },
TEXTURE_BLEND = { "Blend Texture", TEXTURE2D, "blendtex"},
#END

#DEFTAG
ShaderName = "BlendScreen"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_BLEND;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_BLEND_Sampler;


v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex); 
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
  float3 basecolor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler,i.uv).rgb;
  float3 blendcolor = TEXTURE_BLEND.Sample(TEXTURE_BLEND_Sampler,i.uv).rgb;
  float3 rgb = float3(1.0,1.0,1.0) - (float3(1.0,1.0,1.0) - basecolor) * (float3(1.0,1.0,1.0) - blendcolor);
  mainColor = float4(rgb.r,rgb.g,rgb.b,1.0);
}
ENDCG
#END
