CGPROGRAM
#pragma compute readBackVelFieldbyPos

#include "fluid_simulation.inc"

// fieldSrcV1 -> position
// fieldSrcV2 -> velocity
// fieldDstV  -> velocity

float3 _Psize;
float  _ParticleNum;
float  _DeltaTime;

// float4 _DetectFacor;
float  _UseRotate;
float2 _PFacor;

struct ParticleVel 
{
	float4 fVel;
	float4 pVel;
	float	dis;
};

RWStructuredBuffer<float4> fieldPPos;

RWStructuredBuffer<float4> fieldVelS;
RWStructuredBuffer<ParticleVel> fieldPVel ;
RWStructuredBuffer<float4> fieldObstacle;
RWStructuredBuffer<float4> _Write3f;

uint pos2gridcord(float3 pos)
{
	float3 fidx = WorldPos2GridCord(pos);
	uint3  uidx = uint3(fidx);
	return GridCord2GlobalIndex(uidx.x, uidx.y, uidx.z);
}

[numthreads(THREAD_GROUP_SIZE, 1, 1)]
void readBackVelFieldbyPos(int3 id : SV_DispatchThreadID)
{
	int globalIndex = id.x + id.y * (int)_Size.x + id.z * (int)_Size.w;
  
	float3 ppos = fieldPPos[globalIndex].xyz;
	
	float3 fidx = WorldPos2GridCord(ppos);
	uint3  uidx = uint3(fidx);
	uint   grididx =  GridCord2GlobalIndex(uidx.x, uidx.y, uidx.z);
	
	float3 vCenter = fieldVelS[grididx].xyz;
	float d = fieldObstacle[grididx].x;
	
	float3 newPos = ppos + (vCenter - fieldObstacle[grididx].yzw) *  _DeltaTime;
	uint   newgrididx = pos2gridcord(newPos);
	float newd = -fieldObstacle[newgrididx].x;
	
	if(newd < 0 && d  > 0)
	{
		float3 oVel = _PFacor.y * fieldObstacle[grididx].yzw;
		if(length(vCenter) > 0.001f)
		{
			float3 normal = _Write3f[grididx].xyz;	
			float3 fVel = _DeltaTime * vCenter - oVel;
			fVel = (fVel - 2.0f * dot(fVel, normal) * normal);
			fieldPVel[globalIndex].fVel.xyz = fVel;
		}		
		fieldPVel[globalIndex].pVel.xyz = oVel;
		fieldPVel[globalIndex].dis = d;	
	}
	else
	{
		if(length(vCenter) > 0.001f)
		{
			fieldPVel[globalIndex].fVel.xyz = vCenter;
		}
		fieldPVel[globalIndex].dis = 0.0f;
	}

	

							  
}

ENDCG

