

#DEFPARAMS
#END

#DEFTAG
ShaderName = "DepthOnly"
RenderQueue = "Opaque-1"
#END

#DEFPASS Always
COLOR_MASK = COLOR_NONE
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM   
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float3 normal : NORMAL;
	ANI_ATTRIBUTE
};

struct v2f
{ 
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	COMPUTE_BONE_MATERIX(v);

	v2f o;
	float4 pos = ObjectToClipPos(v.vertex);
	o.vertex = UniformNDC(pos);

	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	outColor = float4(1.0,1.0,1.0,1.0);
}
ENDCG
#END
