

#DEFPARAMS
GAUSSIAN_STEP = { "GaussianStep", VEC2, "5.0,5.0" },
FLAG = {"FLAG", FLOAT, "0.0"},

#END

#DEFTAG
ShaderName = "GaussianBlur"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;
//float2 INPUTSIZE;
float2 GAUSSIAN_STEP;
float FLAG;
v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;


	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 gaussianCoord[7];
	float2 inCoord = i.uv;
	float2 step = GAUSSIAN_STEP;
	float2 step2 = step + step;
	float2 step3 = step2 + step;

	gaussianCoord[0] = inCoord;
	if(FLAG>=0){
		gaussianCoord[1] = clamp(inCoord - step, float2(0.001,0.001), float2(0.999,0.999));
		gaussianCoord[2] = clamp(inCoord + step, float2(0.001,0.001), float2(0.999,0.999));
		gaussianCoord[3] = clamp(inCoord - step2, float2(0.001,0.001), float2(0.999,0.999));
		gaussianCoord[4] = clamp(inCoord + step2, float2(0.001,0.001), float2(0.999,0.999));
		gaussianCoord[5] = clamp(inCoord - step3, float2(0.001,0.001), float2(0.999,0.999));
		gaussianCoord[6] = clamp(inCoord + step3, float2(0.001,0.001), float2(0.999,0.999));
	}
	else{
		gaussianCoord[1] = inCoord - step;
		gaussianCoord[2] = inCoord + step;
		gaussianCoord[3] = inCoord - step2;
		gaussianCoord[4] = inCoord + step2;
		gaussianCoord[5] = inCoord - step3;
		gaussianCoord[6] = inCoord + step3;
	}

	float Weight[7];
	Weight[0] = 0.34;
	Weight[1] = Weight[2] = 0.17;
	Weight[3] = Weight[4] = 0.10;
	Weight[5] = Weight[6] = 0.06;
	
	float4 color = float4(0.0,0.0,0.0,0.0);

	color += Weight[0] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[0]);
	if(FLAG>=0){
		color += Weight[1] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[1]);
		color += Weight[2] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[2]);
		color += Weight[3] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[3]);
		color += Weight[4] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[4]);
		color += Weight[5] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[5]);
		color += Weight[6] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[6]);
	}
	else{
		if(gaussianCoord[1].x>=0.001&&gaussianCoord[1].x<=0.999&&gaussianCoord[1].y>=0.001&&gaussianCoord[1].y<=0.999){
			color += Weight[1] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[1]);
		}
		if(gaussianCoord[2].x>=0.001&&gaussianCoord[2].x<=0.999&&gaussianCoord[2].y>=0.001&&gaussianCoord[2].y<=0.999){
			color += Weight[2] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[2]);
		}
		if(gaussianCoord[3].x>=0.001&&gaussianCoord[3].x<=0.999&&gaussianCoord[3].y>=0.001&&gaussianCoord[3].y<=0.999){
			color += Weight[3] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[3]);
		}
		if(gaussianCoord[4].x>=0.001&&gaussianCoord[4].x<=0.999&&gaussianCoord[4].y>=0.001&&gaussianCoord[4].y<=0.999){
			color += Weight[4] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[4]);
		}
		if(gaussianCoord[5].x>=0.001&&gaussianCoord[5].x<=0.999&&gaussianCoord[5].y>=0.001&&gaussianCoord[5].y<=0.999){
			color += Weight[5] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[5]);
		}
		if(gaussianCoord[6].x>=0.001&&gaussianCoord[6].x<=0.999&&gaussianCoord[6].y>=0.001&&gaussianCoord[6].y<=0.999){
			color += Weight[6] * TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, gaussianCoord[6]);
		}
	}

	mainColor = color;
}
ENDCG
#END
