local apolloengine = require "apolloengine"

-- ü
local makeup_refobj = { refcnt = 0 };

function makeup_refobj:new(_scene, _refobj, obj)
  obj = obj or {};
  setmetatable(obj, self);
  self.__index = self;
  obj.scene = _scene;
  obj.refobj = _refobj;
  obj.refcnt = 0;
  return obj
end

function makeup_refobj:GetReference()
  if self.refobj == nil then
    return nil
  end
  self.refcnt = self.refcnt + 1;
end

function makeup_refobj:ReleaseReference()
  if self.refobj == nil then
    return nil
  end
  self.refcnt = self.refcnt - 1;
  if self.refcnt <= 0 then
    self.scene:DeleteNode(self.refobj);
    self.refcnt = 0;
    return true
  end
  return false;
end

function makeup_refobj:GetRefObj()
  return self.refobj;
end

return makeup_refobj;