local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local defined = require "behavior.cartoon_behavior.defined"

local ColorChangeBehavior = venuscore.VenusBehavior:extend("ColorChangeBehavior")

function ColorChangeBehavior:new()
  ColorChangeBehavior.super.new(self)
  self.ColorType = 2
  self.UniformName = defined.color_uniform[self.ColorType]
end

function ColorChangeBehavior:_OnAwake()
  self.render = self.Node:GetComponent(apolloengine.Node.CT_RENDER)
end

function ColorChangeBehavior:_OnUpdate(delta)
end

function ColorChangeBehavior:ChangeColor(type_id, value)
  if type_id == self.ColorType and self.UniformName ~= nil then
    self.render:SetParameter(
      self.UniformName,
      value)
  end
end

ColorChangeBehavior:MemberRegister("ColorType",  
  venuscore.ScriptTypes.ComboType(
    function(thiz)
      local result = {}
      for i = 1, #defined.color_type do
        table.insert(
          result,
          {
            key = defined.color_type[i],
            value = i
          }
        )
      end
      return result
    end
  )
)

ColorChangeBehavior:MemberRegister("UniformName")

return ColorChangeBehavior