local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local nodeutility = require "apolloutility.nodeutility"
local apollonode = require "apolloutility.apollonode"
local bigonn = require "bigonnfunction"
require "utility"
require "venusdebug"


local vnectdection = {}

function vnectdection:Initialize(modelpath)
  local count = venuscore.IServicesSystem:GetThreadCount();
  self.Net = bigonn.NetBigoNN(modelpath);
  self.Session = self.Net:CreateSession(0,count/2);
  self.OutputTensor = bigonn.TensorBigoNN();   --self.Session:GetSessionOutput();
  self.ImageConfig = {
    ["sourceFormat"] = bigonn.TensorBigoNN.RGB,
    ["destFormat"] = bigonn.TensorBigoNN.BGR,
    ["mean"] = {127.5,127.5,127.5},
    ["normal"] = {1/255,1/255,1/255},
    ["destWidth"] = 96,
    ["destHeight"] = 192,
  }
  self.IdList = {0,1,2,3,4,5,6,7,8,9,10,11,12,13}
  self.heatmapsize = {24,48}--{24,48}
  self.scale = 1  -- {24,48}->1, {12,24}->2
  --self.inputname = "input_image";
  --self.outputname = "predict_conv2a/Conv2D";
  self.inputname = "input"
  self.outputname = "stacked_hourglass_1/hourglass_block_3/conv2d_127/Conv2D"
end

function vnectdection:Estimate(rgbtexture)
  local stream = rgbtexture;
  self.InputTensor = bigonn.TensorBigoNN(stream, self.ImageConfig);
  self.Session:SetSessionInput(self.inputname , self.InputTensor);
  self.Session:RunAllPaths();
  self.Session:GetSessioOutput(self.outputname, self.OutputTensor);

  local scoreduv = self.OutputTensor:GaussianHeatMapToTopKScoredUV(self.IdList,0.3,5);
  pos2d, scores = vnectdection:ParseOutput(scoreduv);
  return pos2d, scores
end

function vnectdection:ParseOutput(scoreduv)
  --[[
    inputs:
      scoreduv   -   num_joints * top_k * 3 (score, u, v)
  ]]
  local pos2d = {}
  local scores = {}
  for j = 1, #scoreduv do
    scores[j] = scoreduv[j][1][1]
    local sum_score = 0
    local weighted_pos2d = {0, 0}
    for k = 1, #scoreduv[j] do
      sum_score = sum_score + scoreduv[j][k][1]
      weighted_pos2d[1] = weighted_pos2d[1] + scoreduv[j][k][2] * scoreduv[j][k][1]
      weighted_pos2d[2] = weighted_pos2d[2] + scoreduv[j][k][3] * scoreduv[j][k][1]
    end
    pos2d[j] = {self.scale * weighted_pos2d[1]/sum_score,
                self.scale * weighted_pos2d[2]/sum_score}
  end
  return pos2d, scores
end

return vnectdection;