local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
--local ncnn = require "ncnnfunction"
local videodecet = require "videodecet"
local apollonode = require "apolloutility.apollonode"
local oneeurofilter = require "math.lowpassfilter.oneeurofilter"
    
local lowpassfilter = {}


 
function lowpassfilter:Initialize(dx0, min_cutoff, beta,d_cutoff)
  self.dx0 = dx0;
  self.min_c = min_cutoff;
  self.beta = beta;
  self.d_c = d_cutoff;
  self.eurofilters = {};
  self.startTime = venuscore.ITimerSystem:GetTimevalue();
end    

function lowpassfilter:Filter(values)
  self.filters = {}
  for i=1,#values do
    if self.eurofilters[i] ==nil then
      self.eurofilters[i] = {};
    end
    for j=1,#values[i] do
      if self.eurofilters[i][j] ==nil then
        self.eurofilters[i][j] = oneeurofilter(self:CurrentTime(),values[i][j],self.dx0,self.min_c,self.beta,self.d_c);
      else
        local x = self.eurofilters[i][j]:filter(self:CurrentTime(),values[i][j]);
        values[i][j] = x;
      end
    end
  end
  return values;
end  

function lowpassfilter:CurrentTime(values)
  local now =  venuscore.ITimerSystem:GetTimevalue();
  local def = now - self.startTime;
  return def
end

return lowpassfilter;
