local rendernode = require "apolloutility.apollonode.rendernode"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local quadnode = require "apolloutility.apollonode.quadnode"
local venuscore = require "venuscore"
local TextNode = rendernode:extend();
require "venusdebug"

--scale和旋转不能在外面设置
function TextNode:new(font_Path)
  TextNode.super.new(self);
  self:SetCull(false);
  self:SetShow(true);
  self.fontPath = font_Path;
  apolloengine.ShaderEntity.OUTLINE_COLOR =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_COLOR");
  apolloengine.ShaderEntity.OUTLINE_STRENGTH =apolloengine.IMaterialSystem:NewParameterSlot(apolloengine.ShaderEntity.UNIFORM,"OUTLINE_STRENGTH");
  self.textentity = nil;
  self.m_fontsize = 10;
end
--maxwidth为文本框最大宽度，wordspce为字间距
function TextNode:CreateResource(str, fontSize, color, maxWidth, wordSpace, bold, italic, outlineStrength, outlineColor)
  local tempTextentity = self.textentity;
  if tempTextentity == nil then
    tempTextentity = apolloengine.TextSetEntity();
    tempTextentity:PushMetadata(apolloengine.PathMetadata(self.fontPath));
    tempTextentity:CreateResource();
    self.textentity = tempTextentity;
  end

  self.stringid = tempTextentity:InsertString(str);
  self.tstring = tempTextentity:GetText(self.stringid,mathfunction.vector2(fontSize, fontSize),bold,italic);
  self.glyph_list = self.tstring:GetGlyphList();
  self.m_fontsize = mathfunction.vector2(fontSize, fontSize);

  -- 生成顶点数据用于映射上面生成的图片
  self.vertexstream = apolloengine.VertexStream();
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_POSITION,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 2);
  self.vertexstream:SetVertexType(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0,
          apolloengine.VertexBufferEntity.DT_FLOAT,
          apolloengine.VertexBufferEntity.DT_HALF_FLOAT, 4);

  --创建索引流
  self.indicesstream = apolloengine.IndicesStream();
  self.indicesstream:SetIndicesType(
          apolloengine.IndicesBufferEntity.IT_UINT16);


  -- 计算文字实际占用宽度
  local space = 0;
  local width = 0;
  for _, glyph in pairs(self.glyph_list) do
    width = width + glyph.size.x + space;
  end

  local x = -width / 2;
  local y = -fontSize / 2;
  local startWidth = x;
  -- 初始化顶点
  if color == nil then
    color = mathfunction.vector4(0.0, 0.0, 0.0, 1.0);
  end
  local index = 0;
  for i, glyph in ipairs(self.glyph_list) do
    if i == 1 then
      if glyph.size.x > maxWidth then
        return;  --当文字框宽度无法显示第一个完整字符时，直接不执行渲染
      end
    end
    local  xpos = x + glyph.begin.x;
    local ypos = y - (glyph.size.y - glyph.begin.y);
    local w = glyph.size.x;
    local h = glyph.size.y;

    if not glyph.blank then
      -- lefttop
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos + h));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.x, glyph.uv.y));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, color);


      -- leftbottom
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos, ypos));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.x, glyph.uv.w));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, color);


      -- righttop
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos + h));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.z, glyph.uv.y));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, color);


      -- rightbottom
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_POSITION, mathfunction.vector2(xpos + w, ypos));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COORDNATE0, mathfunction.vector2(glyph.uv.z, glyph.uv.w));
      self.vertexstream:PushVertexData(apolloengine.ShaderEntity.ATTRIBUTE_COLOR0, color);

      -- 顶点数据
      self.indicesstream:PushIndicesData(0 + 4 * index);
      self.indicesstream:PushIndicesData(1 + 4 * index);
      self.indicesstream:PushIndicesData(2 + 4 * index);
      self.indicesstream:PushIndicesData(2 + 4 * index);
      self.indicesstream:PushIndicesData(1 + 4 * index);
      self.indicesstream:PushIndicesData(3 + 4 * index);

      index = index + 1;
    end
    --字间距和文字框的最大宽度，目前没有换行的功能，高度按照字体的大小来决定
    x = x + glyph.size.x + wordSpace;
    if x >= maxWidth + startWidth then
      break
    end
  end

  self.texture = self.tstring:GetTextureEntity();
  self.materialPath = "comm:documents/material/font.material";

  if outlineStrength ~= 0 then
    self.outlineMaterialEntity = self.render:MakeMaterialAttachment();
    self.outlineMaterialEntity:PushMetadata(
            apolloengine.PathMetadata(self.materialPath));
    self.outlineMaterialEntity:SetParameter(apolloengine.ShaderEntity.OUTLINE_COLOR,outlineColor);
    self.outlineMaterialEntity:SetParameter(apolloengine.ShaderEntity.OUTLINE_STRENGTH,mathfunction.vector1(outlineStrength));
  end

  self.lyricMaterialEntity = self.render:MakeMaterialAttachment();
  self.lyricMaterialEntity:PushMetadata(
          apolloengine.PathMetadata(self.materialPath));
  self.lyricMaterialEntity:SetParameter(apolloengine.ShaderEntity.OUTLINE_COLOR,mathfunction.vector4(0.0,0.0,0.0,1.0));
  self.lyricMaterialEntity:SetParameter(apolloengine.ShaderEntity.OUTLINE_STRENGTH,mathfunction.vector1(0.0));


  self.render:PushMetadata(
          apolloengine.RenderObjectMeshMetadate(
                  apolloengine.RenderComponent.RM_TRIANGLES,
                  apolloengine.ReferenceVertexMetadata(
                          apolloengine.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
                          self.vertexstream),
                  apolloengine.ReferenceIndicesMetadata(
                          apolloengine.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
                          self.indicesstream)));
  self.render:CreateResource();

  self:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE, self.texture);

  self.scale = mathfunction.vector3(1, 1, 1)
end

function TextNode:SetLocalScale(s)
  local ns = self.scale * s;
  TextNode.super.SetLocalScale(self, ns);
end

function TextNode:SetLayer(l)
  self.layermin = -9 * 10 ^ l;
  self.layermax = -10 * 10 ^ l;
  self.min = mathfunction.vector3(1, self.layermin, 1);
  self.max = mathfunction.vector3(1, self.layermax, 1);
  self.bindbox = mathfunction.Aabbox3d(self.min, self.max);
  self:SetBindBox(self.bindbox);
end

function TextNode:SetLayerFix(pos, scale)
  if scale == nil then
    scale = 1;
  end
  local newmin = (self.layermin - pos:z()) * 1 / scale;
  local newmax = (self.layermax - pos:z()) * 1 / scale;
  -- lua_debug("SetLayerFix min:"..newmin.." max:"..newmax)
  self.min:Set(1, newmin, 1);
  self.max:Set(1, newmax, 1);
  self.bindbox:SetMin(self.min);
  self.bindbox:SetMax(self.max);
  self:SetBindBox(self.bindbox);
end

function TextNode:GetSize()
  return self.scale;
end

function TextNode:Clear()
  -- 释放资源
  if self.textentity ~= nil then
     self.textentity:ReleaseText(self.stringid, self.m_fontsize);
  end
end

return TextNode;
