local TransNode = require "apolloutility.apollonode.trasnnode"
local spinefunction = require "spinefunction"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local apolloDefine = require "apolloutility.defiend"


--虚拟节点，不包含可渲染的组件
local SpineNode = TransNode:extend();

function SpineNode:new()
  self.isshow = true;
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_SPINE_NODE);
  --self.node = spinefunction.SpineNode();
  --hack 和transnode逻辑保持一致
  self.scale = mathfunction.vector3();
  self.position = mathfunction.vector3();
  self.node:SetName("SpineNode");
  self.render = self.node:GetRenderComponent();
  self.spine = self.node:GetSpineComponent();
  self.trans = self.node:CreateComponent(apolloengine.Node.CT_TRANSFORM);
end

function SpineNode:CreateResource(atlas, skel, material)
  self.spine:PushMetadata(
    apolloengine.PathMetadata(atlas));
  self.spine:PushMetadata(
    apolloengine.PathMetadata(skel));
  self.render:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(material)));
  
  return self.node:CreateResource();
end

--与旧Spine功能兼容
function SpineNode:SetTextureDiffuse(texture)
  self.render:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,texture);
end


function SpineNode:PushAnimation(name, loop, delay)
  self.spine:PushAnimation(name, loop, delay);
end

function SpineNode:ClearAnimation()  
  self.spine:ClearAnimation();
end

function SpineNode:UpdateAnimation(diff)
  return self.node:UpdateAnimation(diff);
end

function SpineNode:SetSkin(name)
  return self.spine:SetSkin(name);
end

function SpineNode:FindBone(name)
  return self.spine:FindBone(name);
end

function SpineNode:SetShow(isshow)
  if self.isshow ~= isshow then
    self.isshow = isshow;
    if isshow then
      self.render:SetRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    else
      self.render:EraseRenderProperty(apolloengine.RenderComponent.RP_SHOW);
    end  
  end
end

function SpineNode:BindPose()
  self.node:BindPose();
end

return SpineNode;