

//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE StandardVertexShader
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_POSITION,				HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,					HIGH,    VEC3,        "in_Normal" },
		    { ATTRIBUTE_TANGENT,				HIGH,    VEC3,        "in_Tangent"},
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC2,        "in_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,             HIGH,    VEC2,        "in_Coordinate1"},
        { ATTRIBUTE_COORDNATE2,             HIGH,    VEC2,        "in_Coordinate2"},
        { ATTRIBUTE_COORDNATE3,             HIGH,    VEC2,        "in_Coordinate3"},

        { CAMERA_VIEWPROJ,					HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },

        { BKG_SCALE_OFFSET,                 HIGH,    VEC4,        "in_BkgScaleOffset"},
        { BKG_UV0ORUV2,               HIGH,  FLOAT,        "in_Bkguv02"},
        { PATTERN_UV3ORUV2,           HIGH,  FLOAT,        "in_Patternuv32"}
    }

    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,   HIGH,    VEC4,        "out_Position" },
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC4,        "out_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,             HIGH,    VEC4,        "out_Coordinate1"},
        { ATTRIBUTE_COORDNATE2,             HIGH,    VEC4,        "out_Coordinate2"},
        { WORLDSPACE_NORMAL,      HIGH,   VEC4,         "out_NormalWS"},
        { WORLDSPACE_TANGENT,     HIGH,   VEC4,         "out_TangentWS"},
        { WORLDSPACE_BINORMAL,    HIGH,   VEC4,         "out_BinormalWS"},
    }

#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;
		vec3 out_PositionWS  = vec3(in_Transfrom * in_Position);
    vec4 out_NormalWS;
    vec4 out_TangentWS;
    vec4 out_BinormalWS;

    out_NormalWS.xyz = (in_WorldRotation * in_Normal);
    out_NormalWS.xyz = normalize(out_NormalWS.xyz);

    out_TangentWS.xyz =  (in_WorldRotation * in_Tangent);
    out_TangentWS.xyz = normalize(out_TangentWS.xyz);

    out_BinormalWS.xyz = (cross(out_TangentWS.xyz, out_NormalWS.xyz));
    out_BinormalWS.xyz = normalize(out_BinormalWS.xyz);

    out_NormalWS.w = out_PositionWS.x;
    out_TangentWS.w = out_PositionWS.y;
    out_BinormalWS.w = out_PositionWS.z;
		
    vec4 out_Coordinate0;
    vec4 out_Coordinate1;
    vec4 out_Coordinate2;

    out_Coordinate0.xy = in_Coordinate0.xy;
    out_Coordinate0.zw = in_Coordinate1.xy;
    
    if (in_Patternuv32 > 0.0)
    {
      out_Coordinate1.zw = in_Coordinate2.xy;
    }
    else
    {
      out_Coordinate1.zw = in_Coordinate3.xy;
    }
    
    if (in_Bkguv02 > 0.0)
    {
      out_Coordinate2.xy = in_Coordinate2.xy * in_BkgScaleOffset.xy + in_BkgScaleOffset.zw;
    }
    else
    {
      out_Coordinate2.xy = in_Coordinate0.xy * in_BkgScaleOffset.xy + in_BkgScaleOffset.zw;
    }
    
    gl_Position = out_Position;
#END_CODE
#END_DEFINE

#SHADER_DEFINE StandardPixelShader
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,             HIGH,    VEC4,        "in_Coordinate0"},
        { ATTRIBUTE_COORDNATE1,             HIGH,    VEC4,        "in_Coordinate1"},
        { ATTRIBUTE_COORDNATE2,             HIGH,    VEC4,        "in_Coordinate2"},
        { WORLDSPACE_NORMAL,      HIGH,   VEC4,         "in_NormalWS"},
        { WORLDSPACE_TANGENT,     HIGH,   VEC4,         "in_TangentWS"},
        { WORLDSPACE_BINORMAL,    HIGH,   VEC4,         "in_BinormalWS"},
        { CAMERA_WORLDPOSITION,	  HIGH,	  VEC3,			"in_CameraPosition"},

        { MAIN_TEXTURE,			  NONE,			TEXTURE2D,		"MainTex" },
        { NORMAL_TEXTURE,		  NONE,			TEXTURE2D,		"NormalTexture" },
        { BKGTINT_TEXTURE,		  NONE,			TEXTURE2D,		"BkgTintTex" },
        { BKGMATERIAL_TEXTURE,	  NONE,			TEXTURE2D,		"BkgMaterialTex" },
        { BKGNORMAL_TEXTURE,      NONE,         TEXTURE2D,      "BkgNormalTex"},
        { PATTERN_ALBEDO_TEXTURE, NONE,         TEXTURE2D,      "PatternAlbedoTex"},
        { PATTERN_NORMAL_TEXTURE, NONE,         TEXTURE2D,      "PatternNormalTex"},

        { BKGNORMAL_INTENSITY,    HIGH,         FLOAT,          "FBkgNormalIntensity"},
        { METALLIC,               HIGH,         FLOAT,          "Metallic"},
        { SMOOTHNESS,             HIGH,         FLOAT,          "Smoothness"},
        { ENVSPEC_INTENSITY,      HIGH,         FLOAT,          "EnvSpecIntensity"},
        { SPECULAR_COLOR,         HIGH,         VEC4,          "SpecularColor"},
        { LIGHT1DIR,              HIGH,         VEC3,          "Light1Dir"},
        { LIGHT1COLOR,            HIGH,         VEC3,          "Light1Color"},
        { LIGHT1INTENSITY,        HIGH,         FLOAT,         "Light1Intensity"},
        { LIGHT2DIR,              HIGH,         VEC3,          "Light2Dir"},
        { LIGHT2COLOR,            HIGH,         VEC3,          "Light2Color"},
        { LIGHT2INTENSITY,        HIGH,         FLOAT,         "Light2Intensity"},
        { CUS_AMBIENT,            HIGH,         VEC4,          "CusAmbient"},
        { BKG_SCALE_OFFSET,       HIGH,         VEC4,          "in_BkgScaleOffset"},
        { SURFACE_COLOR,				  HIGH,	        FLOAT,		"ShadowMask" },
        { AMBIENT_COLOR,		    HIGH,		      VEC3,		"shAmbient" },
        
        { BKG_NORMAL,             HIGH,  FLOAT,        "UseBkgNormal"},
        { PATTERN_ALBEDO,         HIGH,  FLOAT,        "UsePatternAlbedo"},
        { PATTERN_NORMAL,         HIGH,  FLOAT,        "UsePatternNormal"}
    }

    FUNCTION_OUTPUT =
    {
    }
#SHADER_CODE
    
    vec3 worldPos = vec3(in_NormalWS.w, in_TangentWS.w, in_BinormalWS.w);
    vec3 viewDir_S = in_CameraPosition.xyz - worldPos.xyz;
    vec3 viewDir = normalize(viewDir_S);

    vec3 mainNormal = texture2D(NormalTexture, in_Coordinate0.xy).xyz;
    vec3 groundNormal = mainNormal.xyz * 2.0 - 1.0;

    //bkg normal
    vec3 bkgNormal = vec3(0.0, 0.0, 1.0);
    if (UseBkgNormal > 0.0)
    {
      float tileCount = min(abs(in_BkgScaleOffset.x), abs(in_BkgScaleOffset.y));
      tileCount -= 20.0;
      tileCount = max(0.0, tileCount);
      float rimReduce = tileCount > 0.0 ? 1.0 : 0.0;
      float len = sqrt(dot(viewDir_S, viewDir_S));
      len = 0.9333333 - 0.33333331 * len;
      len = clamp(len, 0.0, 1.0);
      float BkgNormalIntensity = mix(1.0, len, rimReduce);

      vec2 texNormal = texture2D(BkgNormalTex, in_Coordinate2.xy).xy;
      bkgNormal = vec3(texNormal.xy, 0.0);
      float dotV;
      bkgNormal.xy = (bkgNormal.xy * 2.0 - 1.0) * FBkgNormalIntensity * BkgNormalIntensity;
      dotV = dot(bkgNormal.xy, bkgNormal.xy);
      bkgNormal.z = sqrt(1.0 - min(dotV, 1.0));
    }

    if (UsePatternNormal > 0.0)
    {
      float weight = mainNormal.z;
      vec2 patternNormal = texture2D(PatternNormalTex, in_Coordinate2.xy).xy;
      vec3 patternNormal1 = vec3(patternNormal.xy * 2.0 - 1.0, 0.0);
      patternNormal1.z = sqrt(1.0 - dot(patternNormal1.xy, patternNormal1.xy));

      weight *= texture2D(PatternAlbedoTex, in_Coordinate1.zw).w;
      vec3 outNormal = mix(bkgNormal, patternNormal1, weight);
      bkgNormal = outNormal;
    }

    // blend normal
    vec3 n1 = groundNormal;
    vec3 n2 = bkgNormal;
    n1 += vec3(0.0, 0.0, 1.0);
    n2 *= vec3(-1.0, -1.0, 1.0);
    vec3 blendedNormal = n1 * dot(n1, n2) / n1.z - n2;
    float backLightingWeight = 1.0;

    if(!gl_FrontFacing)
    {
         blendedNormal = -blendedNormal;
         backLightingWeight = 0.0;
    }

    // normal in world space
    vec3 worldNormal = blendedNormal.x * in_TangentWS.xyz + blendedNormal.y * in_BinormalWS.xyz
					+ blendedNormal.z * in_NormalWS.xyz;
    worldNormal = normalize(worldNormal);

    // common
    //vec3 light1Dir = normalize(Light1Dir);
	  //vec3 light2Dir = normalize(Light2Dir);
    vec3 light1Dir = (Light1Dir);
	  vec3 light2Dir = (Light2Dir);
	  vec3 h1 = normalize(viewDir + light1Dir);
	  float nv = max(dot(worldNormal, viewDir), 0.0);
	  float nh1 = max(dot(worldNormal, h1), 0.0);

    // main color
    vec3 mainColor = texture2D(MainTex, in_Coordinate0.xy).xyz;

    // bkg tint
    vec3 bgTintColor = texture2D(BkgTintTex, in_Coordinate0.zw).xyz;
    
    if (UsePatternAlbedo > 0.0)
    {
      vec4 patternAlbedo = texture2D(PatternAlbedoTex, in_Coordinate1.zw).xyzw;
      float bkgTintWeight = mainNormal.z * patternAlbedo.w;
      bgTintColor = mix(bgTintColor.xyz, patternAlbedo.xyz, bkgTintWeight);
    }

    // blend main and bkg
    mainColor *= bgTintColor;
	  mainColor *= mainColor;

    // diffuse
    vec3 shadowColor = vec3(ShadowMask, ShadowMask, ShadowMask);
    vec3 diffuse = vec3(0.0, 0.0, 0.0);
    float nl1 = dot(worldNormal, light1Dir);
	  float nl1Warp = max((nl1 + 1.0) * 0.5, 0.0);
	  nl1 = max(nl1, 0.0);
	  diffuse += nl1 * Light1Color * Light1Intensity * shadowColor;

    float nl2 = (dot(worldNormal, light2Dir) + 0.5) * 0.7;
    nl2 = max(nl2, 0.0);
	  nl2 = nl2 * nl2;
	  nl2 = nl2 * nl2;
	  nl2 = nl2 * nl2;
	  diffuse += nl2 * Light2Color * Light2Intensity * backLightingWeight;

    //vec3 outDiffuse = (diffuse + CusAmbient.xyz) * mainColor;
    vec3 outDiffuse = (diffuse + shAmbient.xyz) * mainColor;

    // sample Material
    vec2 metalSmooth = texture2D(BkgMaterialTex, in_Coordinate0.zw).xy * vec2(Metallic, Smoothness);
    vec2 invSmoothMetal = vec2(1.0, 1.0) - metalSmooth.yx;
	  float roughness = invSmoothMetal.x;
	  float metal = metalSmooth.x;

    // fresnel
    float fresnel = 1.0 - nv;
	  fresnel *= fresnel;
	  fresnel *= fresnel;
    
    /*ibl
    float metalCo = metalSmooth.x + EnvSpecIntensity - 1.0;
    metalCo = clamp(metalCo, 0.0, 1.0);
    float grazingTerm = max(metalCo, metalSmooth.y);
    float iblWeight = mix(metalCo, grazingTerm, fresnel);
    
    vec3 reflectDir = reflect(-viewDir, worldNormal);
    float perceptualRoughness = (1.7 - 0.7 * roughness) * roughness;
    float mipmapLevel = perceptualRoughness * 4.0;
    #ifdef GL_EXT_shader_texture_lod
    vec4 rgbm = textureCubeLod(skybox, reflectDir, mipmapLevel);
    #else
    vec4 rgbm = textureCube(skybox, reflectDir);
    #endif
    vec3 iblColor = rgbm.xyz * iblWeight * EnvSpecIntensity;
    */
    
    vec3 iblColor = vec3(0.0, 0.0, 0.0);

    // specular color
    vec3 DielectricSpec = vec3(0.2209163, 0.2209163, 0.2209163);
	  vec3 specularCol = mix(DielectricSpec, mainColor, metal);
    
    // D
    float modifyRoughness = max(roughness * roughness, 0.1);
    float NdotH = nh1;
    float a2 = modifyRoughness * modifyRoughness;
    float d = (NdotH * a2 - NdotH) * NdotH + 1.0f; // 2 mad
	  d = 0.31830988618f * a2 / (d * d + 1e-7f);
	  d = min(d, 100.0);

    // F
    float f0 = mix(DielectricSpec.x, 1.0, metal);
	  float f = f0 + (1.0 - f0) * fresnel;

    vec3 outSpecular = (d * f * nl1Warp * SpecularColor.xyz * Light1Color.xyz * Light1Intensity + iblColor) * specularCol;
    gl_FragColor = vec4(outDiffuse.xyz * invSmoothMetal.y + outSpecular.xyz, 1.0);

    
#END_CODE
#END_DEFINE



