
#DEFPARAMS
MASK_TEXTURE = { "Mask Tex", TEXTURE2D, "white" },
CUSTOM_TEXTURE = { "Custom Tex", TEXTURE2D, "white" },
MASK_CHANNEL = { "Mask Channel", VEC3, "1.0,1.0,1.0" },
UV_SCALER = { "UV Scale", VEC2, "1.0,1.0" },
#END

#DEFTAG
ShaderName = "ImageBlitTrasnparent"
RenderQueue = "Opaque+1"
#END


#DEFPASS ForwardBase
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_BLEND, SRC_ALPHA,ONE_MINUS_SRC_ALPHA, ONE, ONE }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { FORWARDBASE }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
	float2 mask_uv : TEXCOORD1;
};

Texture2D MASK_TEXTURE;
Texture2D CUSTOM_TEXTURE;
SamplerState MASK_Sampler;
SamplerState CUSTOM_Sampler;
float3 MASK_CHANNEL;
float2 UV_SCALER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
    float x = (o.vertex.x + 1.0) / 2.0;
    float y = 1.0 - (o.vertex.y + 1.0) / 2.0;
	o.mask_uv = float2(x, y);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 uvCoordinate = (i.uv - float2(0.5,0.5)) * UV_SCALER + float2(0.5,0.5);
	float4 custom = CUSTOM_TEXTURE.Sample(CUSTOM_Sampler, uvCoordinate);
	float4 mask = MASK_TEXTURE.Sample(MASK_Sampler, i.mask_uv);
	float maskV = mask.b * MASK_CHANNEL.r + mask.g * MASK_CHANNEL.g + mask.r * MASK_CHANNEL.b;
	mainColor = float4(custom.xyz, maskV * custom.a);
}
ENDCG
#END




#DEFPASS PostEffect
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { UNIVERSAL_POST_EFFECT }


CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
	float2 mask_uv : TEXCOORD1;
};

Texture2D MASK_TEXTURE;
Texture2D CUSTOM_TEXTURE;
SamplerState MASK_Sampler;
SamplerState CUSTOM_Sampler;
float3 MASK_CHANNEL;
float2 UV_SCALER;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
    float x = (o.vertex.x + 1.0) / 2.0;
    float y = 1.0 - (o.vertex.y + 1.0) / 2.0;
	o.mask_uv = float2(x, y);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	float2 uvCoordinate = (i.uv - float2(0.5,0.5)) * UV_SCALER + float2(0.5,0.5);
	float4 custom = CUSTOM_TEXTURE.Sample(CUSTOM_Sampler, uvCoordinate);
	float4 mask = MASK_TEXTURE.Sample(MASK_Sampler, i.mask_uv);
	float maskV = mask.b * MASK_CHANNEL.r + mask.g * MASK_CHANNEL.g + mask.r * MASK_CHANNEL.b;
	mainColor = float4(custom.xyz, maskV * custom.a);
}
ENDCG
#END