#DEFPARAMS
#END

#DEFTAG
ShaderName = "Portrait"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_BACK, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "functions/liveportrait.inc"
#include "common.inc"

struct appdata   
{
    float3 vertex           : POSITION;
    float2 uv               : TEXCOORD0;
    float  enableModelView  : COLOR;
};

struct v2f
{
    float2 uv               : TEXCOORD0;
    float4 vertex           : SV_POSITION;
};

float4x4 PROJECTION;
float4x4 MODELVIEW;

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

float     ENABLE_WRINKLE;
Texture2D TEXTURE_WRINKLE;
Texture2D TEXTURE_FOREHEAD_MASK;
Texture2D TEXTURE_LDECREE_MASK;
Texture2D TEXTURE_RDECREE_MASK;
SamplerState TEXTURE_WRINKLE_Sampler;
SamplerState TEXTURE_FOREHEAD_MASK_Sampler;
SamplerState TEXTURE_LDECREE_MASK_Sampler;
SamplerState TEXTURE_RDECREE_MASK_Sampler;
float     FOREHEAD_FACTOR;
float     DECREE_FACTOR;

float3    ORIGIN_FOREHEAD_CENTER[2];
float3    CUR_FOREHEAD_CENTER[2];
float3    ORIGIN_LMOUTH_CORNER[2];
float3    CUR_LMOUTH_CORNER[2];
float3    ORIGIN_RMOUTH_CORNER[2];
float3    CUR_RMOUTH_CORNER[2];

v2f vert(appdata v)
{
    float4 pos;
    if (v.enableModelView > 0.5)
        pos = mul(float4(v.vertex, 1.0), mul(MODELVIEW, PROJECTION));
    else
        pos = mul(float4(v.vertex, 1.0), PROJECTION);
      
    v2f o;  
    o.uv = v.uv;
    o.vertex = UniformNDC(pos);
    return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    if (ENABLE_WRINKLE > 0.5)
    {
        float4 img_color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
        float4 img_color_yuv = RGB2YUV(img_color);
        
        float isForeHeadRegion = TEXTURE_FOREHEAD_MASK.Sample(TEXTURE_FOREHEAD_MASK_Sampler, i.uv).r;
        float isLDecreeRegion = TEXTURE_LDECREE_MASK.Sample(TEXTURE_LDECREE_MASK_Sampler, i.uv).r;
        float isRDecreeRegion = TEXTURE_RDECREE_MASK.Sample(TEXTURE_RDECREE_MASK_Sampler, i.uv).r;
        
        float cur_wrinkle_extent = 0.0;
        if (isForeHeadRegion > 0.5)
        {
            // get wrinkle extent according to distance change
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_FOREHEAD_CENTER[1], ORIGIN_FOREHEAD_CENTER[1], 
                                        CUR_FOREHEAD_CENTER[0], ORIGIN_FOREHEAD_CENTER[0],
                                        FOREHEAD_FACTOR);                                     
        }
        else if (isLDecreeRegion > 0.5)
        {
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_LMOUTH_CORNER[1], ORIGIN_LMOUTH_CORNER[1], 
                                        CUR_LMOUTH_CORNER[0], ORIGIN_LMOUTH_CORNER[0], 
                                        DECREE_FACTOR);
        }
        else if (isRDecreeRegion > 0.5)
        {
            cur_wrinkle_extent = GetCurWrinkleExtent(
                                        CUR_RMOUTH_CORNER[1], ORIGIN_RMOUTH_CORNER[1], 
                                        CUR_RMOUTH_CORNER[0], ORIGIN_RMOUTH_CORNER[0],
                                        DECREE_FACTOR);
        }
        // wrinkle factor with full extent
        float full_idensity = TEXTURE_WRINKLE.Sample(TEXTURE_WRINKLE_Sampler, i.uv).r;
        
        // wrinkle factor with current extent
        float cur_wrinkle_factor = lerp(1.0, full_idensity, cur_wrinkle_extent);    
        img_color_yuv.r *= cur_wrinkle_factor;

        // generate final color
        mainColor = YUV2RGB(img_color_yuv);
    }
    else
    {
        mainColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
    } 
}
ENDCG
#END

