#DEFPARAMS
#END

#DEFTAG
ShaderName = "FaceMorph"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag

struct appdata   
{
	float2 vertex           : POSITION;
	float2 uv0              : TEXCOORD0;
    float2 uv1              : TEXCOORD1;
};

struct v2f
{
	float2 uv0              : TEXCOORD0;
    float2 uv1              : TEXCOORD1;
	float4 vertex           : SV_POSITION;
};

Texture2D TEXTURE0;
Texture2D TEXTURE1;
SamplerState TEXTURE_Sampler0;
SamplerState TEXTURE_Sampler1;
float     ALPHA;


v2f vert(appdata v)
{
	v2f o;
   
	o.uv0 = v.uv0;
    o.uv1 = v.uv1;
    o.vertex = float4(v.vertex, 0.0, 1.0);
	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
    float4 inputColor0 = TEXTURE0.Sample(TEXTURE_Sampler0, i.uv0);
    float4 inputColor1 = TEXTURE1.Sample(TEXTURE_Sampler1, i.uv1);
    mainColor = lerp(inputColor0, inputColor1, ALPHA);   
}
ENDCG
#END


