
#DEFPARAMS

#END

#DEFTAG
ShaderName = "haircolor_sharpen"
RenderQueue = "Overlay+10"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGB
ALPAH_MODE ={ ALPAH_BLEND, SRC_ALPHA, ONE_MINUS_SRC_ALPHA, ONE, ONE}
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 in_Position : POSITION;
	float2 in_Coordinate : TEXCOORD0;
};

struct v2f
{
	float2 out_Coordinate : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

v2f vert(appdata v)
{
	v2f o;
	
	o.vertex = UniformNDC(v.in_Position);
	o.out_Coordinate = v.in_Coordinate.xy;
	return o;
}

Texture2D TEXTURE_DIFFUSE;
Texture2D TEXTURE_MASK;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState TEXTURE_MASK_Sampler;
float2 TEXTURE_SIZE;
float SHARPEN_STRENGTH;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	half2 in_TexSize = TEXTURE_SIZE;
	float2 in_Coordinate = i.out_Coordinate;
	float in_SharpenStregth = SHARPEN_STRENGTH;

	float2 offset0=float2(-1.0,-1.0);
	float2 offset1=float2(0.0,-1.0);
	float2 offset2=float2(1.0,-1.0);
	float2 offset3=float2(-1.0,0.0); 
	float2 offset4=float2(0.0,0.0); 
	float2 offset5=float2(1.0,0.0);
	float2 offset6=float2(-1.0,1.0);
	float2 offset7=float2(0.0,1.0);
	float2 offset8=float2(1.0,1.0);

  	float2 in_LaplaceCoord[9];
    in_LaplaceCoord[0] = in_Coordinate.xy + offset0.xy/in_TexSize;
	in_LaplaceCoord[1] = in_Coordinate.xy + offset1.xy/in_TexSize;
	in_LaplaceCoord[2] = in_Coordinate.xy + offset2.xy/in_TexSize;
	in_LaplaceCoord[3] = in_Coordinate.xy + offset3.xy/in_TexSize;
	in_LaplaceCoord[4] = in_Coordinate.xy + offset4.xy/in_TexSize;
	in_LaplaceCoord[5] = in_Coordinate.xy + offset5.xy/in_TexSize;
	in_LaplaceCoord[6] = in_Coordinate.xy + offset6.xy/in_TexSize;
	in_LaplaceCoord[7] = in_Coordinate.xy + offset7.xy/in_TexSize;
	in_LaplaceCoord[8] = in_Coordinate.xy + offset8.xy/in_TexSize;

	float scaleFactor = in_SharpenStregth;//给出最终求和时的加权因子(为调整亮度)
	float kernelValue0 = 0.0;  float kernelValue1 = -1.0; float kernelValue2 = 0.0;
	float kernelValue3 = -1.0; float kernelValue4 = 5.0;  float kernelValue5 = -1.0;
	float kernelValue6 = 0.0;  float kernelValue7 = -1.0; float kernelValue8 = 0.0;
	float4 sum;
	float4 cTemp0,cTemp1,cTemp2,cTemp3,cTemp4,cTemp5,cTemp6,cTemp7,cTemp8;
	cTemp0=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[0]);
	cTemp1=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[1]);
	cTemp2=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[2]);
	cTemp3=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[3]);
	cTemp4=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[4]);
	cTemp5=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[5]);
	cTemp6=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[6]);
	cTemp7=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[7]);
	cTemp8=TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, in_LaplaceCoord[8]);
    float4 mask = TEXTURE_MASK.Sample(TEXTURE_MASK_Sampler, float2(in_LaplaceCoord[0].x, in_LaplaceCoord[0].y));

	sum =kernelValue0*cTemp0+kernelValue1*cTemp1+kernelValue2*cTemp2+
		 kernelValue3*cTemp3+kernelValue4*cTemp4+kernelValue5*cTemp5+
	     kernelValue6*cTemp6+kernelValue7*cTemp7+kernelValue8*cTemp8;
    //vec4 outColor = (sum * scaleFactor + cTemp4 * (1.0 - scaleFactor)) * mask.r + cTemp4 * (1.0 - mask.r);
   float4 outColor = (sum * scaleFactor + cTemp4 * (1.0 - scaleFactor));
   mainColor = float4(outColor.rgb,mask.r);
}

ENDCG
#END



