local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local waterripple = {}
waterripple.material = nil;
waterripple.renderobject = nil;
waterripple.Queue = 107;


function waterripple:Initialize(host, size)  
    --<!--  set the offsets parameters in vertex shader -->
  self.COUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"COUNT");
  
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/waterripple.material" );
  self.material:SetParameter(self.COUNT, mathfunction.vector1(0.0));
  return self.Queue;
end

function waterripple:Resizeview(size)
  --self:_SetParam(size);
end

function waterripple:Process(context, Original, Scene, Output) 
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return waterripple;