
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local BlueDefined = require "bluecore.bluedefined"

local RotateXYZ = BlueNode:extend();

---- 游戏运行模式
function RotateXYZ:new(...)
  RotateXYZ.super.new(self,...)
end

function RotateXYZ:_OnUpdate(args)
  local rot = args[1];
  return mathfunction.Mathutility:YawPitchRoll(rot.my, rot.mx, rot.mz);
end


---- 编辑器模式



RotateXYZ:RegisterInput(1, mathfunction.vector3:RTTI(), "rotation", "设置轴向旋转角", mathfunction.vector3(0, 0, 0));

RotateXYZ:RegisterOutput(1, mathfunction.Quaternion:RTTI(), "quaternion", "四元数");

RotateXYZ:SetFunctionName("RotateXYZ");

RotateXYZ:SetFunctionType(BlueDefined.STATIC_FUNCTION_NODE);

return RotateXYZ ;
