local apolloengine = require "apolloengine"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local ResetAllContent = BlueNode:extend();

local BD = require "bluecore.bluedefined"
---- 游戏运行模式
function ResetAllContent:new(...)
  ResetAllContent.super.new(self,...);
end


function ResetAllContent:_OnUpdate(args)
  self:_RecursiveResetNode(args[1]);
end


function ResetAllContent:_RecursiveResetNode(rootNode)
  --FIXME(hjh) 目前仅支持FrameAni Ani的Reset  在蓝图Reset中把node和component的active状态设置回去
  local AniCom = rootNode:GetComponent(apolloengine.Node.CT_ANIMATION);
  if AniCom then
    AniCom:Reset();
  end
  local FrameAniCom = rootNode:GetComponent(apolloengine.Node.CT_FRAME_PLAYER);
  if FrameAniCom then
    FrameAniCom:Reset();
  end
  local BlueCom = rootNode:GetComponent(apolloengine.Node.CT_BLUEPRINT);
  if BlueCom and BlueCom.Instances[BD.LuaPath] then
    BlueCom.Instances[BD.LuaPath]:Reset();
  end
  local AIMorphCom = rootNode:GetComponent(apolloengine.Node.CT_CV_AIMorph);
  if AIMorphCom then
    AIMorphCom:Reset();
  end
  local childNode = rootNode:GetChildrens();
  for i = 1, #childNode do
    self:_RecursiveResetNode(childNode[i]);
  end
end

--新素材不再使用
function ResetAllContent:isHide()
  return true;
end

---- 编辑器模式
ResetAllContent:RegisterInput(1, apolloengine.Node:RTTI(), "target", "递归遍历子节点重置信息", BlueSelf());

ResetAllContent:RegisterExecInput(1, "exec", "Execute");

ResetAllContent:RegisterExecOutput(1, "exec", "Execute");

ResetAllContent:SetFunctionName("Reset All Content");

return ResetAllContent;

