local BlueNode = require "bluecore.bluenode"
local ForInRange = BlueNode:extend();

local Types = require "venuscore.rtti.types"

---- 游戏运行模式
function ForInRange:new(...)
  ForInRange.super.new(self, ...)
  self._indexArray = {}
  self._isRunning = false
  self._isAbort = false
end

function ForInRange:Update(execIdx)
  if execIdx == 2 then
    return self:_Break();
  elseif execIdx == 1 then
    return self:_Loop();
  end
end


function ForInRange:_Break()
  if _KRATOSEDITOR then
    local BuEd = require "bluecore.editor.blueutility_ed"
    BuEd:BlueDebugYield(self);
  end
  self._isAbort = true ;
  return nil
end

function ForInRange:_Loop()

  if self.is_running then
    LOG("[ForLoopBreak:Update] is running");
    return nil
  end

  local inputs = self:_GetInput()

  -- 初始化状态
  local startIdx = inputs[1];
  local endIdx   = inputs[2] ;
  local isRandom   = inputs[3] ;

  local length = #self._indexArray ;
  local newLength = endIdx - startIdx + 1 ;
  self._isRunning = true
  self._currentIndex = 1
  self._isAbort = false

  if newLength ~= length then
    self._indexArray = {}
    for i = 1, newLength do
      table.insert(self._indexArray, i);
    end
  end

  if isRandom then
    local half = math.floor(newLength  * 0.8)
    local offset = math.random(0  ,newLength - half)
    for i = 1, half do
      local replace = math.random(1, newLength)
      local old = self._indexArray[i + offset]
      self._indexArray[i + offset] = self._indexArray[replace]
      self._indexArray[replace] = old
    end
  end

  -- Step.2 执行循环 Loop引脚被调用
  local loopbody = self.nextExecNodes[1];
  if loopbody ~= nil then
    for execIndex, orderIndex in pairs(self._indexArray) do

      self.outputResults = {orderIndex, execIndex}

      if _KRATOSEDITOR then
        local BuEd = require "bluecore.editor.blueutility_ed"
        BuEd:BlueDebugYield(self);
      end

      local lastNode = self
      local execIdx  = 1
      local nextIdx  = self.nextExecIndex[execIdx];
      local nextNode = self.nextExecNodes[execIdx]

      while nextNode ~= nil do
        if _KRATOSEDITOR then
          local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
          self.graph:AddExecLinkList(link_uid);
        end
        lastNode = nextNode
        execIdx  = nextNode:Update(nextIdx)
        nextIdx  = nextNode.nextExecIndex[execIdx]
        nextNode = nextNode.nextExecNodes[execIdx]
      end

      if self._isAbort then
        LOG("for break it, exec="..tostring(execIndex).."; order="..tostring(orderIndex))
        break;
      end
    end
  end

  -- 恢复状态
  self._isRunning = false
  self._isAbort = false

  return 2
end

function ForInRange:GetOutputByIndex(index)
  return self.outputResults[index];
end

ForInRange:RegisterInput(1, Types.IntType, "Start", "start index", 1);
ForInRange:RegisterInput(2, Types.IntType, "End", "end index, loop range [start,end]", 1);
ForInRange:RegisterInput(3, Types.BoolType, "Random", "random order", false);
ForInRange:RegisterOutput(1, Types.IntType, "Order Index", "order index(random)");
ForInRange:RegisterOutput(2, Types.IntType, "Exec Index", "execute index(sequence)");

ForInRange:RegisterExecInput(1, "Exec", "执行");
ForInRange:RegisterExecInput(2, "Break", "执行", true);

ForInRange:RegisterExecOutput(1, "Loop Body", "执行");
ForInRange:RegisterExecOutput(2, "Completed", "执行");

ForInRange:SetFunctionName("For In Range");

return ForInRange;

