local BD = require "bluecore.bluedefined"
local BATNode = require "bluecore.base.blue_anytype_node"
local Types = require "venuscore.rtti.types"

local InsertArrayElementByIndex = BATNode:extend();

---- 游戏运行模式
function InsertArrayElementByIndex:new(...)
  InsertArrayElementByIndex.super.new(self, ...)
end

function InsertArrayElementByIndex:_OnUpdate(args)
  local array = args[1]
  local index = args[2]
  local new_element = args[3];

  if array == nil then
    ERROR("[InsertArrayElementByIndex] array is nil")
    return nil ;
  end
  if new_element == nil then
    ERROR("[InsertArrayElementByIndex] new_element is nil")
    return array ;
  end
  if index <= 0 or index > #array then
    if index == 1 and #array == 0 then --支持空表 从idx=1 进行插入
      WARNING("[InsertArrayElementByIndex] Insert an Empty Table!!!");
      table.insert(array, index, new_element);
      return array;
    end
    ERROR("[InsertArrayElementByIndex] index "..tostring(index).." is illegal ".."legal range is [1,"..tostring(#array).."]");
    return array ;
  end
  table.insert(array, index, new_element);
  return array;
end

---- 编辑器模式
InsertArrayElementByIndex:RegisterExecInput(1, "Exec", "执行");
InsertArrayElementByIndex:RegisterExecOutput(1, "Exec", "执行");

InsertArrayElementByIndex:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", Types.AnyArrayType(), false, BATNode.DEFAULT_GROUP);
InsertArrayElementByIndex:RegisterInput(2, Types.IntType, "Index", "数组索引(从1开始)", 1, false, nil)
InsertArrayElementByIndex:RegisterInput(3, Types.AnyType, "element_new", "新元素值", Types.AnyType(), false, BATNode.DEFAULT_GROUP);
InsertArrayElementByIndex:RegisterOutput(1, Types.AnyArrayType, "result", "输出数组", Types.AnyArrayType(), false , BATNode.DEFAULT_GROUP);

InsertArrayElementByIndex:SetFunctionName("Insert Array Element");

return InsertArrayElementByIndex ;