local apolloengine = require "apolloengine"
local mf = require "mathfunction"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local GetLocalScaleVec3 = BlueNode:extend();

function GetLocalScaleVec3:new(...)
  GetLocalScaleVec3.super.new(self, ...)
end

function GetLocalScaleVec3:_OnUpdate(args)
  local transformComponent_target = args[1];
  local result = transformComponent_target:GetLocalScale();
  return result
end

GetLocalScaleVec3:RegisterInput(1, apolloengine.TransformComponent:RTTI(), "target", "TransformComponent", BlueSelf());
GetLocalScaleVec3:RegisterOutput(1, mf.vector3:RTTI() , "scale", "vector3");

GetLocalScaleVec3:SetFunctionName("GetLocalScale(vec3)");

return GetLocalScaleVec3;
