local AE = require "apolloengine"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"

local GetLocalQuaternion = BlueNode:extend();

function GetLocalQuaternion:new(...)
  GetLocalQuaternion.super.new(self, ...)
end

function GetLocalQuaternion:_OnUpdate(args)
  local transformTarget = args[1];
  return transformTarget.LocalRotation;
end

GetLocalQuaternion:RegisterInput(1, AE.TransformComponent:RTTI(), "target", "TransformComponent组件", BlueSelf());
GetLocalQuaternion:RegisterOutput(1, mf.Quaternion:RTTI(), "Quaternion", "Quaternion");

GetLocalQuaternion:SetFunctionName("Get Local Quaternion");

return GetLocalQuaternion;

