local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local GetPostEffectValue = require "bluecore.base.get_posteffect_value"
local GetPostEffectVector4 = GetPostEffectValue:extend();


---- 游戏运行模式
function GetPostEffectVector4:new(...)
  GetPostEffectVector4.super.new(self, ...)
end




function GetPostEffectVector4:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector4:RTTI();
end



GetPostEffectVector4:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
GetPostEffectVector4:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); 

GetPostEffectVector4:RegisterOutput(1, mathfunction.vector4:RTTI(), "ParaValue", "参数值");

GetPostEffectVector4:SetFunctionName("GetPostEffectVector4");


return GetPostEffectVector4 ;

